/*
 * Decompiled with CFR 0.152.
 */
package com.examstack.portal.service;

import com.examstack.common.domain.training.Training;
import com.examstack.common.domain.training.TrainingSection;
import com.examstack.common.domain.training.TrainingSectionProcess;
import com.examstack.common.domain.training.UserTrainingHistory;
import com.examstack.common.util.Page;
import com.examstack.portal.persistence.TrainingMapper;
import com.examstack.portal.service.TrainingService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="trainingService")
public class TrainingServiceImpl
implements TrainingService {
    @Autowired
    private TrainingMapper trainingMapper;

    public List<Training> getTrainingList(Page<Training> page) {
        return this.trainingMapper.getTrainingList(page);
    }

    public List<TrainingSection> getTrainingSectionByTrainingId(int trainingId, Page<TrainingSection> page) {
        return this.trainingMapper.getTrainingSectionByTrainingId(trainingId, page);
    }

    public List<TrainingSection> getTrainingSectionById(int sectionId, Page<TrainingSection> page) {
        return this.trainingMapper.getTrainingSectionById(sectionId, page);
    }

    public UserTrainingHistory getTrainingHistBySectionId(int sectionId, int userId) {
        return this.trainingMapper.getTrainingHistBySectionId(sectionId, userId);
    }

    public void setUserTrainingHistory(UserTrainingHistory hist) {
        this.trainingMapper.setUserTrainingHistory(hist);
    }

    public Map<Integer, List<TrainingSectionProcess>> getTrainingSectionProcessMapByUserId(int userId) {
        List processList = this.trainingMapper.getTrainingSectionProcessListByUserId(userId, null);
        HashMap<Integer, List<TrainingSectionProcess>> map = new HashMap<Integer, List<TrainingSectionProcess>>();
        for (TrainingSectionProcess process : processList) {
            List<TrainingSectionProcess> tmpList = new ArrayList<TrainingSectionProcess>();
            if (map.containsKey(process.getTrainingId())) {
                tmpList = map.get(process.getTrainingId());
            }
            tmpList.add(process);
            map.put(process.getTrainingId(), tmpList);
        }
        return map;
    }
}

