/*
 * Decompiled with CFR 0.152.
 */
package com.examstack.portal.service;

import com.examstack.common.domain.user.Department;
import com.examstack.common.domain.user.Group;
import com.examstack.common.domain.user.Role;
import com.examstack.common.domain.user.User;
import com.examstack.common.util.Page;
import com.examstack.portal.persistence.UserMapper;
import com.examstack.portal.service.UserService;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UserServiceImpl
implements UserService {
    @Autowired
    public UserMapper userMapper;

    @Transactional
    public int addUser(User user, String authority, int groupId, HashMap<String, Role> roleMap) {
        try {
            int userId = -1;
            this.userMapper.insertUser(user);
            userId = user.getUserId();
            this.userMapper.grantUserRole(userId, roleMap.get(authority).getRoleId());
            if (user.getDepId() != 0) {
                this.userMapper.addUser2Dep(userId, user.getDepId());
            }
            return userId;
        }
        catch (Exception e) {
            String cause = e.getCause().getMessage();
            throw new RuntimeException(cause);
        }
    }

    @Transactional
    public void updateUser(User user, String oldPassword) {
        try {
            this.userMapper.updateUser(user, oldPassword);
            this.userMapper.deleteUser2Dep(user.getUserId());
            this.userMapper.addUser2Dep(user.getUserId(), user.getDepId());
        }
        catch (Exception e) {
            String cause = e.getCause().getMessage();
            throw new RuntimeException(cause);
        }
    }

    public List<Group> getGroupListByUserId(int userId, Page<Group> page) {
        return this.userMapper.getGroupListByUserId(userId, page);
    }

    public HashMap<String, Role> getRoleMap() {
        List roleList = this.userMapper.getRoleList();
        HashMap<String, Role> map = new HashMap<String, Role>();
        for (Role r : roleList) {
            map.put(r.getAuthority(), r);
        }
        return map;
    }

    public void changeUserStatus(List<Integer> idList, boolean enabled) {
        this.userMapper.changeUserStatus(idList, enabled);
    }

    public void addUserGroup(int userId, int groupId) {
        this.userMapper.addUserGroup(userId, groupId);
    }

    public void deleteUserGroup(int userId, int groupId, int managerId) {
        this.userMapper.deleteUserGroup(userId, groupId, managerId);
    }

    public List<Department> getDepList(Page<Department> page) {
        return this.userMapper.getDepList(page);
    }

    public User getUserByName(String userName) {
        return this.userMapper.getUserByName(userName);
    }

    public void updateUserPwd(User user, String oldPwd) {
        this.userMapper.updateUser(user, oldPwd);
    }
}

