/*
 * Decompiled with CFR 0.152.
 */
package com.gccloud.dataset.service.impl.label;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.gccloud.dataset.dao.DatasetLabelDao;
import com.gccloud.dataset.entity.DatasetLabelEntity;
import com.gccloud.dataset.entity.LabelEntity;
import com.gccloud.dataset.service.IDatasetLabelService;
import com.gccloud.dataset.vo.DatasetLabelVO;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class DatasetLabelServiceImpl
extends ServiceImpl<DatasetLabelDao, DatasetLabelEntity>
implements IDatasetLabelService {
    @Override
    public List<DatasetLabelVO> getDatasetByLabelId(String labelId) {
        return ((DatasetLabelDao)this.getBaseMapper()).getDatasetByLabelId(labelId);
    }

    @Override
    public List<LabelEntity> getLabelByDatasetId(String datasetId) {
        return ((DatasetLabelDao)this.getBaseMapper()).getLabelByDatasetId(datasetId);
    }

    @Override
    public void delete(String datasetId, String labelId) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(DatasetLabelEntity::getDatasetId, (Object)datasetId);
        wrapper.eq(DatasetLabelEntity::getLabelId, (Object)labelId);
        this.remove((Wrapper)wrapper);
    }

    @Override
    public void deleteByDatasetId(String datasetId) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(DatasetLabelEntity::getDatasetId, (Object)datasetId);
        this.remove((Wrapper)wrapper);
    }

    @Override
    public void deleteByLabelId(String labelId) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(DatasetLabelEntity::getLabelId, (Object)labelId);
        this.remove((Wrapper)wrapper);
    }

    @Override
    public void addByDatasetId(String datasetId, List<String> labelIds) {
        if (StringUtils.isBlank((CharSequence)datasetId)) {
            return;
        }
        if (labelIds == null || labelIds.isEmpty()) {
            return;
        }
        ArrayList list = Lists.newArrayList();
        for (String labelId : labelIds) {
            DatasetLabelEntity entity = new DatasetLabelEntity();
            entity.setDatasetId(datasetId);
            entity.setLabelId(labelId);
            list.add(entity);
        }
        this.saveBatch(list);
    }

    @Override
    public void addByLabelId(String labelId, List<String> datasetIds) {
        if (StringUtils.isBlank((CharSequence)labelId)) {
            return;
        }
        if (datasetIds == null || datasetIds.isEmpty()) {
            return;
        }
        ArrayList list = Lists.newArrayList();
        for (String datasetId : datasetIds) {
            DatasetLabelEntity entity = new DatasetLabelEntity();
            entity.setDatasetId(datasetId);
            entity.setLabelId(labelId);
            list.add(entity);
        }
        this.saveBatch(list);
    }

    @Override
    public List<String> getDatasetIdsByLabelIds(List<String> labelIds) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.select((Object[])new SFunction[]{DatasetLabelEntity::getDatasetId});
        wrapper.in(DatasetLabelEntity::getLabelId, labelIds);
        List list = this.list((Wrapper)wrapper);
        List datasetIds = list.stream().map(DatasetLabelEntity::getDatasetId).distinct().collect(Lists::newArrayList, List::add, List::addAll);
        return datasetIds;
    }

    @Override
    public List<String> getDatasetIdsByLabelIds(List<String> labelIds, boolean allMatch) {
        if (!allMatch) {
            return this.getDatasetIdsByLabelIds(labelIds);
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.select((Object[])new SFunction[]{DatasetLabelEntity::getDatasetId});
        wrapper.in(DatasetLabelEntity::getLabelId, labelIds);
        wrapper.groupBy(DatasetLabelEntity::getDatasetId);
        wrapper.having("COUNT(DISTINCT label_Id) = " + labelIds.size(), new Object[0]);
        List list = this.list((Wrapper)wrapper);
        List datasetIds = list.stream().map(DatasetLabelEntity::getDatasetId).collect(Lists::newArrayList, List::add, List::addAll);
        return datasetIds;
    }

    @Override
    public List<String> getLabelIdsByDatasetId(String datasetId) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.select((Object[])new SFunction[]{DatasetLabelEntity::getLabelId});
        wrapper.eq(DatasetLabelEntity::getDatasetId, (Object)datasetId);
        List list = this.list((Wrapper)wrapper);
        List labelIds = list.stream().map(DatasetLabelEntity::getLabelId).distinct().collect(Lists::newArrayList, List::add, List::addAll);
        return labelIds;
    }
}

