/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.jwt;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.primeframework.jwt.Verifier;
import org.primeframework.jwt.domain.Algorithm;
import org.primeframework.jwt.domain.Header;
import org.primeframework.jwt.domain.InvalidJWTException;
import org.primeframework.jwt.domain.JWT;
import org.primeframework.jwt.domain.JWTExpiredException;
import org.primeframework.jwt.domain.JWTUnavailableForProcessingException;
import org.primeframework.jwt.domain.MissingSignatureException;
import org.primeframework.jwt.domain.MissingVerifierException;
import org.primeframework.jwt.domain.NoneNotAllowedException;
import org.primeframework.jwt.json.Mapper;

public class JWTDecoder {
    private static JWTDecoder instance;

    public static JWTDecoder getInstance() {
        if (instance == null) {
            instance = new JWTDecoder();
        }
        return instance;
    }

    public JWT decode(String encodedJWT, Verifier ... verifiers) {
        Objects.requireNonNull(encodedJWT);
        Objects.requireNonNull(verifiers);
        String[] parts = this.getParts(encodedJWT);
        Header header = Mapper.deserialize(this.base64Decode(parts[0]), Header.class);
        Verifier verifier = Arrays.stream(verifiers).filter(v -> v.canVerify(header.algorithm)).findFirst().orElse(null);
        boolean allowNoneAlgorithm = verifiers.length == 0;
        return this.validate(encodedJWT, parts, header, verifier, allowNoneAlgorithm);
    }

    public JWT decode(String encodedJWT, Map<String, Verifier> verifiers) {
        return this.decode(encodedJWT, verifiers, (Header h) -> h.get("kid"));
    }

    public JWT decode(String encodedJWT, Map<String, Verifier> verifiers, Function<Header, String> keyFunction) {
        Objects.requireNonNull(encodedJWT);
        Objects.requireNonNull(verifiers);
        Objects.requireNonNull(keyFunction);
        String[] parts = this.getParts(encodedJWT);
        Header header = Mapper.deserialize(this.base64Decode(parts[0]), Header.class);
        String key = keyFunction.apply(header);
        Verifier verifier = verifiers.get(key);
        boolean allowNoneAlgorithm = verifiers.isEmpty();
        return this.validate(encodedJWT, parts, header, verifier, allowNoneAlgorithm);
    }

    private byte[] base64Decode(String string) {
        try {
            return Base64.getUrlDecoder().decode(string);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidJWTException("The encoded JWT is not properly Base64 encoded.", e);
        }
    }

    private String[] getParts(String encodedJWT) {
        String[] parts = encodedJWT.split("\\.");
        if (parts.length == 3 || parts.length == 2 && encodedJWT.endsWith(".")) {
            return parts;
        }
        throw new InvalidJWTException("The encoded JWT is not properly formatted. Expected a three part dot separated string.");
    }

    private JWT validate(String encodedJWT, String[] parts, Header header, Verifier verifier, boolean allowNoneAlgorithm) {
        JWT jwt;
        if (parts.length == 2) {
            if (!allowNoneAlgorithm) {
                throw new NoneNotAllowedException();
            }
            if (header.algorithm != Algorithm.none) {
                throw new MissingSignatureException("Your provided a JWT with the algorithm [" + header.algorithm.getName() + "] but it is missing a signature");
            }
        } else {
            if (header.algorithm == Algorithm.none) {
                throw new InvalidJWTException("You provided a JWT with a signature and an algorithm of none");
            }
            if (verifier == null) {
                throw new MissingVerifierException("No Verifier has been provided for verify a signature signed using [" + header.algorithm.getName() + "]");
            }
            if (!verifier.canVerify(header.algorithm)) {
                throw new MissingVerifierException("No Verifier has been provided for verify a signature signed using [" + header.algorithm.getName() + "]");
            }
            this.verifySignature(verifier, header, parts[2], encodedJWT);
        }
        if ((jwt = Mapper.deserialize(this.base64Decode(parts[1]), JWT.class)).isExpired()) {
            throw new JWTExpiredException();
        }
        if (jwt.isUnavailableForProcessing()) {
            throw new JWTUnavailableForProcessingException();
        }
        return jwt;
    }

    private void verifySignature(Verifier verifier, Header header, String signature, String encodedJWT) {
        int index = encodedJWT.lastIndexOf(".");
        byte[] message = encodedJWT.substring(0, index).getBytes(StandardCharsets.UTF_8);
        byte[] signatureBytes = this.base64Decode(signature);
        verifier.verify(header.algorithm, message, signatureBytes);
    }
}

