/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.io;

import com.vertica.io.MessageType;
import com.vertica.io.ResponseMessage;
import com.vertica.io.VStream;
import java.io.IOException;

public final class MarsResponseMessage
extends ResponseMessage {
    public static final int MARS_RETURN_CREATED = 1;
    public static final int MARS_RETURN_FETCH = 2;
    public static final int MARS_RETURN_CLOSE = 4;
    public static final int MARS_RETURN_CANCEL = 8;
    public static final int MARS_RETURN_ERROR = 16;
    int m_rid;
    int m_status;
    long m_remainCount;

    protected MarsResponseMessage(VStream vStream) {
        super(vStream);
    }

    @Override
    protected void buildMessage(int n) throws IOException {
        if (n != 16) {
            throw new IOException("Protocol Error. Expected 16 byte left in message, but actual length is " + n);
        }
        this.m_rid = this.m_vStream.ReceiveIntegerR(4);
        this.m_status = this.m_vStream.ReceiveIntegerR(4);
        this.m_remainCount = this.m_vStream.ReceiveLong();
    }

    public int getResultID() {
        return this.m_rid;
    }

    public int getStatus() {
        return this.m_status;
    }

    public long getRemainRowcount() {
        return this.m_remainCount;
    }

    @Override
    public MessageType getType() {
        return MessageType.MarsResponse;
    }

    @Override
    public Object[] getDebugInfo() {
        Object[] objectArray = new Object[]{this.getType(), "ResultSet ID: " + this.m_rid, "Status: " + this.m_status + " [" + ((1 & this.m_status) > 0 ? "Created " : "") + "" + ((2 & this.m_status) > 0 ? " Fetched " : "") + "" + ((4 & this.m_status) > 0 ? " Closed " : "") + "" + ((8 & this.m_status) > 0 ? " Canceled " : "") + "" + ((0x10 & this.m_status) > 0 ? " Error" : "") + "]", "Remaining rowcount: " + this.m_remainCount};
        return objectArray;
    }
}

