/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.lifecycle.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.RemovalCause;
import com.github.benmanes.caffeine.cache.RemovalListener;
import com.yomahub.liteflow.flow.element.Chain;
import com.yomahub.liteflow.flow.element.Condition;
import com.yomahub.liteflow.lifecycle.PostProcessChainExecuteLifeCycle;
import com.yomahub.liteflow.meta.LiteflowMetaOperator;
import com.yomahub.liteflow.slot.Slot;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ChainCacheLifeCycle
implements PostProcessChainExecuteLifeCycle {
    private final Cache<String, ChainState> cache;
    private static ChainCacheLifeCycle INSTANCE;

    private ChainCacheLifeCycle(int capacity) {
        this.cache = Caffeine.newBuilder().maximumSize((long)capacity).evictionListener((RemovalListener)new ChainRemovalListener()).build();
    }

    @Override
    public void postProcessBeforeChainExecute(String chainId, Slot slot) {
        this.cache.get((Object)chainId, key -> ChainState.newActiveState());
    }

    @Override
    public void postProcessAfterChainExecute(String chainId, Slot slot) {
        if (!this.isActive(chainId) && !this.isCleaned(chainId)) {
            ChainCacheLifeCycle.cleanChain(chainId);
        }
    }

    public Cache<String, ChainState> getCache() {
        return this.cache;
    }

    private boolean isCleaned(String chainId) {
        Chain chain = LiteflowMetaOperator.getChain(chainId);
        if (ObjectUtil.isNull((Object)chain)) {
            return true;
        }
        List<Condition> conditionList = chain.getConditionList();
        return CollUtil.isEmpty(conditionList);
    }

    private boolean isActive(String chainId) {
        ChainState chainState = (ChainState)this.cache.getIfPresent((Object)chainId);
        return ObjectUtil.isNotNull((Object)chainState) && chainState.isActive();
    }

    private static void cleanChain(String chainId) {
        Chain chain = LiteflowMetaOperator.getChain(chainId);
        if (ObjectUtil.isNull((Object)chain)) {
            return;
        }
        chain.setCompiled(false);
        chain.setConditionList(null);
    }

    public static synchronized boolean initIfAbsent(int capacity) {
        if (ObjectUtil.isNull((Object)INSTANCE)) {
            INSTANCE = new ChainCacheLifeCycle(capacity);
            return true;
        }
        return false;
    }

    public static ChainCacheLifeCycle getLifeCycle() {
        return INSTANCE;
    }

    private static class ChainRemovalListener
    implements RemovalListener<String, ChainState> {
        private ChainRemovalListener() {
        }

        public void onRemoval(@Nullable String chainId, @Nullable ChainState chainState, @NonNull RemovalCause removalCause) {
            if (ObjectUtil.isNotNull((Object)chainState)) {
                chainState.setActive(false);
            }
            ChainCacheLifeCycle.cleanChain(chainId);
        }
    }

    public static class ChainState {
        private volatile boolean active;

        public ChainState(boolean active) {
            this.active = active;
        }

        public boolean isActive() {
            return this.active;
        }

        public void setActive(boolean active) {
            this.active = active;
        }

        public static ChainState newActiveState() {
            return new ChainState(true);
        }
    }
}

