/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.uap.tenant.utils;

import com.yonyou.uap.tenant.sendmessage.SendLogoutMessage;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jasig.cas.ticket.ServiceTicket;
import org.jasig.cas.ticket.Ticket;
import org.jasig.cas.ticket.TicketGrantingTicket;
import org.jasig.cas.ticket.registry.AbstractDistributedTicketRegistry;
import org.springframework.util.Assert;
import uap.web.cache.CacheManager;
import uap.web.core.ContextHolder;

public class RedisTicketRegistry
extends AbstractDistributedTicketRegistry {
    private static CacheManager cacheManager = null;
    private static final String TICKET_SSO = "ticket_sso";
    private SendLogoutMessage sendlogout = null;

    public SendLogoutMessage getSendlogout() {
        return this.sendlogout;
    }

    public void setSendlogout(SendLogoutMessage sendlogout) {
        this.sendlogout = sendlogout;
    }

    private synchronized CacheManager getCacheManager() {
        if (cacheManager != null) {
            return cacheManager;
        }
        cacheManager = (CacheManager)ContextHolder.getContext().getBean("cacheManager");
        return cacheManager;
    }

    public void addTicket(Ticket ticket) {
        Ticket oldTgtTicket;
        TicketGrantingTicket tgtTicket;
        cacheManager = this.getCacheManager();
        Assert.notNull((Object)ticket, (String)"ticket cannot be null");
        this.logger.debug("Added ticket [{}] to registry.", (Object)ticket.getId());
        cacheManager.putTicketCacheAttribute(TICKET_SSO, ticket.getId(), (Serializable)ticket);
        if (ticket instanceof ServiceTicket && (tgtTicket = ticket.getGrantingTicket()) != null && (oldTgtTicket = this.getTicket(tgtTicket.getId())) != null) {
            cacheManager.putTicketCacheAttribute(TICKET_SSO, tgtTicket.getId(), (Serializable)tgtTicket);
            cacheManager.putTicketCacheAttribute("SSO_USERNAME_" + tgtTicket.getAuthentication().getPrincipal().getId(), tgtTicket.getId(), (Serializable)((Object)tgtTicket.getId()));
        }
    }

    public Ticket getTicket(String ticketId) {
        cacheManager = this.getCacheManager();
        if (ticketId == null) {
            return null;
        }
        this.logger.debug("Attempting to retrieve ticket [{}]", (Object)ticketId);
        Ticket ticket = (Ticket)cacheManager.getTicketCacheAttribute(TICKET_SSO, ticketId);
        if (ticket != null) {
            this.logger.debug("Ticket [{}] found in registry.", (Object)ticketId);
        }
        return ticket;
    }

    public boolean deleteTicket(String ticketId) {
        cacheManager = this.getCacheManager();
        if (ticketId == null) {
            return false;
        }
        Ticket ticket = this.getTicket(ticketId);
        if (ticket == null) {
            return false;
        }
        if (ticket instanceof TicketGrantingTicket) {
            this.sendLogout(ticket);
        }
        this.logger.debug("Removing ticket [{}] from the registry.", (Object)ticket);
        return cacheManager.removeCacheAttribute(TICKET_SSO, ticketId);
    }

    private void sendLogout(Ticket ticket) {
        this.sendlogout.sendEventMessage(ticket);
    }

    public Collection<Ticket> getTickets() {
        Map tcache = this.getTicketsFromRedis();
        return Collections.unmodifiableCollection(tcache.values());
    }

    protected void updateTicket(Ticket ticket) {
        this.addTicket(ticket);
    }

    protected boolean needsCallback() {
        return true;
    }

    private Map<String, Ticket> getTicketsFromRedis() {
        cacheManager = this.getCacheManager();
        Map tickmap = cacheManager.getAllTicketAttrCache(TICKET_SSO);
        ConcurrentHashMap<String, Ticket> tcache = new ConcurrentHashMap<String, Ticket>();
        for (Map.Entry entry : tickmap.entrySet()) {
            String key = (String)entry.getKey();
            Ticket ticket = (Ticket)entry.getValue();
            tcache.put(key, ticket);
        }
        return tcache;
    }
}

