/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.uap.tenant.utils;

import com.alibaba.fastjson.JSONObject;
import com.yonyou.uap.tenant.log.CasLog;
import com.yonyou.uap.tenant.utils.CasPropertyUtil;
import com.yonyou.uap.tenant.utils.DateUtils;
import com.yonyou.uap.tenant.utils.HttpRequest;
import com.yonyou.uap.tenant.utils.TenantPasswordEncoder;
import com.yonyou.uap.tenant.utils.UserValidate;
import com.yonyou.uap.tenant.web.filter.PerformanceLoggerCollector;
import com.yonyouccs.bean.AuthResult;
import com.yonyouccs.bean.JitGatewayUtilBean;
import com.yonyouccs.config.CaConfig;
import com.yonyouccs.gateway.util.JitGatewayUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.login.FailedLoginException;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.XMLWriter;
import org.jasig.cas.adaptors.jdbc.AbstractJdbcUsernamePasswordAuthenticationHandler;
import org.jasig.cas.authentication.ContinueRegisterException;
import org.jasig.cas.authentication.Credential;
import org.jasig.cas.authentication.HandlerResult;
import org.jasig.cas.authentication.ModifyPWFailedException;
import org.jasig.cas.authentication.NeedModifyPWException;
import org.jasig.cas.authentication.PreventedException;
import org.jasig.cas.authentication.UsernamePasswordCredential;
import org.jasig.cas.authentication.handler.PasswordEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.webflow.execution.RequestContextHolder;
import org.springside.modules.mapper.JsonMapper;
import org.springside.modules.security.utils.Digests;
import org.springside.modules.utils.Encodes;
import sun.misc.BASE64Encoder;
import uap.web.cache.CacheManager;
import uap.web.core.ContextHolder;
import uap.web.utils.RSAUtils;

public class TenantAuthenticationHandler
extends AbstractJdbcUsernamePasswordAuthenticationHandler
implements InitializingBean {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String SQL_PREFIX = "select count(1) from ";
    private static final String USERPWD_LOGIN_TYPE = "0";
    private static final String PHONEVER_LOGIN_TYPE = "1";
    private static final String QR_LOGIN_TYPE = "2";
    @NotNull
    private String fieldUser;
    @NotNull
    private String fieldPassword;
    @NotNull
    private String tableUsers;
    private String sql;

    private CasLog getCasLog() {
        CasLog casLog = (CasLog)ContextHolder.getContext().getBean("securityLog");
        return casLog;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final HandlerResult authenticateUsernamePasswordInternal(UsernamePasswordCredential credential) throws GeneralSecurityException, PreventedException {
        PerformanceLoggerCollector.start((String)"authenticateUsernamePasswordInternal");
        String is_security_ca = credential.getIs_security_ca();
        RequestContextHolder.getRequestContext().getFlowScope().put("is_security_ca", (Object)is_security_ca);
        if (QR_LOGIN_TYPE.equals(is_security_ca)) {
            JitGatewayUtilBean jitGatewayUtilBean = new JitGatewayUtilBean();
            jitGatewayUtilBean.setAuthMode(credential.getAuthMode());
            jitGatewayUtilBean.setToken("");
            CacheManager cacheManager = (CacheManager)ContextHolder.getContext().getBean("cacheManager");
            jitGatewayUtilBean.setOriginal_data(cacheManager.get("original_data").toString());
            jitGatewayUtilBean.setOriginal_jsp(credential.getOriginal());
            jitGatewayUtilBean.setSigned_data(credential.getSigned_data());
            jitGatewayUtilBean.setRemoteAddr("127.0.0.1");
            AuthResult authResult = this.auth(jitGatewayUtilBean);
            if (!authResult.isSuccess()) {
                this.getCasLog().recordLog(credential, "SSO_LOGININ", "FAILED", new String[]{"CA\u8bc1\u4e66\u4e0d\u5408\u6cd5"});
                RequestContextHolder.getRequestContext().getFlowScope().put("modifyPW_msg", (Object)"CA\u8bc1\u4e66\u4e0d\u5408\u6cd5");
                throw new PreventedException("\u8bc1\u4e66\u4e0d\u5408\u6cd5", new Throwable());
            }
            String idCode = null;
            String subjectDn = authResult.getSubjectDN();
            if (StringUtils.isNotBlank((String)subjectDn)) {
                String[] dnArr;
                for (String dnString : dnArr = subjectDn.split(",")) {
                    String keydn = dnString.split("=")[0].trim();
                    String keyValue = dnString.split("=")[1].trim();
                    if (!"T".equals(keydn)) continue;
                    idCode = keyValue;
                }
            }
            if (StringUtils.isBlank(idCode)) {
                this.getCasLog().recordLog(credential, "SSO_LOGININ", "FAILED", new String[]{"CA\u8bc1\u4e66\u4e0d\u5408\u6cd5"});
                RequestContextHolder.getRequestContext().getFlowScope().put("modifyPW_msg", (Object)"CA\u8bc1\u4e66\u4e0d\u5408\u6cd5");
                throw new PreventedException("\u8bc1\u4e66\u4e0d\u5408\u6cd5", new Throwable());
            }
            String sql = "SELECT t.* from pub_tenant_user t where t.ca_code = ? and t.dr = 0";
            List resultList = this.getJdbcTemplate().queryForList(sql, new Object[]{idCode});
            if (resultList.size() <= 0) {
                this.getCasLog().recordLog(credential, "SSO_LOGININ", "FAILED", new String[]{"\u8be5CA\u8bc1\u4e66\u627e\u4e0d\u5bf9\u5bf9\u5e94\u7684\u4eba"});
                RequestContextHolder.getRequestContext().getFlowScope().put("modifyPW_msg", (Object)"\u8be5CA\u8bc1\u4e66\u627e\u4e0d\u5bf9\u5bf9\u5e94\u7684\u4eba");
                throw new PreventedException("\u8be5\u8bc1\u4e66\u627e\u4e0d\u5bf9\u5bf9\u5e94\u7684\u4eba", new Throwable());
            }
            Map resultMap = (Map)resultList.get(0);
            credential.setUsername(resultMap.get("user_code").toString());
            credential.setPassword(resultMap.get("user_password").toString());
        } else if (PHONEVER_LOGIN_TYPE.equals(is_security_ca)) {
            if (StringUtils.isBlank((String)credential.getUserphone())) {
                this.getCasLog().recordLog(credential, "SSO_LOGININ", "FAILED", new String[]{"\u7528\u6237\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01"});
                RequestContextHolder.getRequestContext().getFlowScope().put("modifyPW_msg", (Object)"\u7528\u6237\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                throw new PreventedException("\u7528\u6237\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", new Throwable());
            }
            if (StringUtils.isBlank((String)credential.getUservertycode())) {
                this.getCasLog().recordLog(credential, "SSO_LOGININ", "FAILED", new String[]{"\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01"});
                RequestContextHolder.getRequestContext().getFlowScope().put("modifyPW_msg", (Object)"\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                throw new PreventedException("\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", new Throwable());
            }
            String validateMsgUrl = CasPropertyUtil.getPropertyByKey((String)"validatePhoneCode.url");
            validateMsgUrl = validateMsgUrl + "?phone=" + credential.getUserphone() + "&validate=" + credential.getUservertycode();
            JSONObject param = new JSONObject();
            param.put("phone", (Object)credential.getUserphone());
            param.put("validate", (Object)credential.getUservertycode());
            String string = HttpRequest.sendPost2((String)validateMsgUrl, (String)param.toString());
            JSONObject obj = JSONObject.parseObject((String)string);
            String status = obj.getString("status");
            String msg = obj.getString("msg");
            if (USERPWD_LOGIN_TYPE.equals(status)) {
                this.getCasLog().recordLog(credential, "SSO_LOGININ", "FAILED", new String[]{msg});
                RequestContextHolder.getRequestContext().getFlowScope().put("modifyPW_msg", (Object)msg);
                throw new PreventedException(msg, new Throwable());
            }
            String sql = "SELECT t.* from pub_tenant_user t where t.user_mobile = ? and t.dr = 0";
            List resultList = this.getJdbcTemplate().queryForList(sql, new Object[]{credential.getUserphone()});
            if (resultList != null && resultList.size() == 1) {
                Map resultMap = (Map)resultList.get(0);
                credential.setUsername(resultMap.get("user_code").toString());
                credential.setPassword(resultMap.get("user_password").toString());
            } else {
                this.getCasLog().recordLog(credential, "SSO_LOGININ", "FAILED", new String[]{"\u8be5\u624b\u673a\u53f7\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728"});
                RequestContextHolder.getRequestContext().getFlowScope().put("modifyPW_msg", (Object)"\u8be5\u624b\u673a\u53f7\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728");
                throw new PreventedException("\u8be5\u624b\u673a\u53f7\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728", new Throwable());
            }
        }
        if (StringUtils.isBlank((String)credential.getUsername()) || StringUtils.isBlank((String)credential.getPassword())) {
            this.getCasLog().recordLog(credential, "SSO_LOGININ", "FAILED", new String[]{"\u7528\u6237\u540d\u6216\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01"});
            RequestContextHolder.getRequestContext().getFlowScope().put("modifyPW_msg", (Object)"\u7528\u6237\u540d\u6216\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            throw new PreventedException("\u7528\u6237\u540d\u6216\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", new Throwable());
        }
        String username = credential.getUsername();
        if (credential.isFirstSuccess()) {
            return this.createHandlerResult((Credential)credential, this.principalFactory.createPrincipal(username), (List)null);
        }
        String newpass = credential.getNewpass();
        if (newpass != null && !newpass.equals("null")) {
            return this.changeUserPwd(credential);
        }
        if (1 == credential.getIsAutoLogin()) {
            return this.authenticateUsernamePasswordInternal_autoLogin(credential);
        }
        if (!StringUtils.isEmpty((String)credential.getOpenid())) {
            HandlerResult handlerResult = this.authenticateUsernamePasswordInternal_weixin(credential);
            if (handlerResult != null) {
                return handlerResult;
            }
            if (credential.getOpenid().equalsIgnoreCase(credential.getUsername())) {
                credential.setUsername("");
                credential.setPassword("");
                RequestContextHolder.getRequestContext().getFlowScope().put("modifyPW_msg", (Object)"\u672a\u7ed1\u5b9a\u5fae\u4fe1\u8d26\u6237");
                throw new PreventedException("\u767b\u5f55\u5931\u8d25\uff1a\u672a\u7ed1\u5b9a\u5fae\u4fe1\u8d26\u6237", new Throwable());
            }
        }
        if (StringUtils.isEmpty((String)credential.getVerify_code())) {
            return this.authenticateUsernamePasswordInternal_default(credential);
        }
        String string = "false";
        try {
            PerformanceLoggerCollector.start((String)"UserValidate.validate");
            String string2 = UserValidate.validate((UsernamePasswordCredential)credential, (JdbcTemplate)this.getJdbcTemplate());
            PerformanceLoggerCollector.stop((String)"UserValidate.validate");
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)string2)) {
                this.getCasLog().recordLog(credential, "SSO_LOGININ", "FAILED", new String[]{"\u7cfb\u7edf\u8fde\u63a5\u5f02\u5e38"});
                RequestContextHolder.getRequestContext().getFlowScope().put("modifyPW_msg", (Object)"\u7cfb\u7edf\u8fde\u63a5\u5f02\u5e38");
            }
            PerformanceLoggerCollector.start((String)"JSONObject.fromObject");
            JSONObject jsonObj = JSONObject.parseObject((String)string2);
            PerformanceLoggerCollector.stop((String)"JSONObject.fromObject");
            if (QR_LOGIN_TYPE.equalsIgnoreCase(String.valueOf(jsonObj.get((Object)"status")))) {
                JSONObject user = jsonObj.getJSONObject("user");
                if (user != null) {
                    String userId = user.getString("userId");
                    String userMobile = user.getString("userMobile");
                    String userCode = user.getString("userCode");
                    if (userId != null) {
                        String sql = "SELECT t.salt from pub_tenant_user t where t.user_id = ?";
                        String salt = (String)this.getJdbcTemplate().queryForObject(sql, String.class, new Object[]{userId});
                        if (userMobile != null && salt != null) {
                            credential.setPhoneNum(userMobile);
                            credential.setSalt(salt);
                            credential.setUserCode(userCode);
                        }
                    }
                }
                throw new NeedModifyPWException(username + " need modify password.");
            }
            if (USERPWD_LOGIN_TYPE.equalsIgnoreCase(String.valueOf(jsonObj.get((Object)"status")))) {
                this.getCasLog().recordLog(credential, "SSO_LOGININ", "FAILED", new String[]{String.valueOf(jsonObj.get((Object)"msg"))});
                RequestContextHolder.getRequestContext().getFlowScope().put("modifyPW_msg", jsonObj.get((Object)"msg"));
                throw new PreventedException("user lock " + username, new Throwable());
            }
            if ("4".equalsIgnoreCase(String.valueOf(jsonObj.get((Object)"status")))) {
                RequestContextHolder.getRequestContext().getFlowScope().put("modifyPW_msg", (Object)"\u767b\u5f55\u5931\u8d25\uff0c\u8bf7\u5230<a href=\"https://www.yonyouccs.com/icop-website/signin\">\u7528\u53cb\u5efa\u7b51\u4e91\u5b98\u7f51</a>\u4e2a\u4eba\u4e2d\u5fc3\u5b8c\u6210\u4f01\u4e1a\u8d44\u8d28\u5f55\u5165\u3002");
                throw new PreventedException("\u767b\u5f55\u5931\u8d25\uff0c\u8bf7\u5230\u5b98\u7f51\u4e2a\u4eba\u4e2d\u5fc3\u5b8c\u6210\u4f01\u4e1a\u8d44\u8d28\u5f55\u5165", new Throwable());
            }
            PerformanceLoggerCollector.start((String)"parmas");
            HashMap<String, Object> attr = new HashMap<String, Object>();
            Object usertype = jsonObj.get((Object)"usertype");
            attr.put("userType", usertype);
            JSONObject userobj = (JSONObject)jsonObj.get((Object)"user");
            String userId = null;
            String userCode = null;
            if (userobj != null) {
                String tenant = userobj.get((Object)"tenantId").toString();
                String tenantid = tenant == null ? null : tenant;
                userId = (String)userobj.get((Object)"userId");
                attr.put("userId", userId);
                String typeId = String.valueOf(userobj.get((Object)"typeId"));
                attr.put("typeAlias", typeId);
                userCode = (String)userobj.get((Object)"userCode");
                attr.put("userCode", userCode);
                credential.setTenantid(tenantid);
                credential.setAttrparam(attr);
            }
            PerformanceLoggerCollector.stop((String)"parmas");
            this.saveWeixin(credential, userCode);
            if (PHONEVER_LOGIN_TYPE.equalsIgnoreCase(String.valueOf(jsonObj.get((Object)"status")))) {
                this.writeLastLoginDate(userCode);
            }
        }
        catch (Exception var14) {
            this.getCasLog().recordLog(credential, "SSO_LOGININ", "FAILED", new String[0]);
            if (var14 instanceof NeedModifyPWException) {
                throw new NeedModifyPWException(username + " need modify password.");
            }
            if (var14 instanceof ContinueRegisterException) {
                throw new ContinueRegisterException(username + " need contine to register");
            }
            this.logger.error(var14.getMessage(), (Throwable)var14);
            throw new PreventedException("SQL exception while executing query for " + username, (Throwable)var14);
        }
        credential.setFirstSuccess(true);
        this.getCasLog().recordLog(credential, "SSO_LOGININ", "SUCCESS", new String[0]);
        PerformanceLoggerCollector.stop((String)"authenticateUsernamePasswordInternal");
        return this.createHandlerResult((Credential)credential, this.principalFactory.createPrincipal(username), (List)null);
    }

    private HandlerResult changeUserPwd(UsernamePasswordCredential credential) throws ModifyPWFailedException {
        try {
            String result = UserValidate.modifyPW((UsernamePasswordCredential)credential);
            JsonMapper objectMapper = new JsonMapper();
            Map map = (Map)objectMapper.fromJson(result, Map.class);
            if (map.get("status").toString().equals(PHONEVER_LOGIN_TYPE)) {
                credential.setPassword(credential.getNewpass());
                credential.setNewpass((String)null);
                credential.setFirstSuccess(true);
                HashMap attr = new HashMap();
                Object usertype = map.get("usertype");
                attr.put("userType", usertype);
                Object userobj = map.get("user");
                String tenantid = (String)((HashMap)userobj).get("tenantId");
                String userId = (String)((Map)userobj).get("userId");
                attr.put("userId", userId);
                String userCode = (String)((Map)userobj).get("userCode");
                attr.put("userCode", userCode);
                String typeId = String.valueOf(((Map)userobj).get("typeId"));
                attr.put("typeAlias", typeId);
                credential.setTenantid(tenantid);
                credential.setAttrparam(attr);
                this.writeLastLoginDate(userCode);
            }
            if (map.get("status").toString().equals(USERPWD_LOGIN_TYPE)) {
                RequestContextHolder.getRequestContext().getFlowScope().put("modifyPW_msg", map.get("msg"));
                RequestContextHolder.getRequestContext().getFlowScope().put("modifyPW_fail", (Object)true);
                throw new ModifyPWFailedException(credential.getUsername() + "   modify password failed.");
            }
        }
        catch (Exception var12) {
            this.logger.error(var12.getMessage(), (Throwable)var12);
            this.getCasLog().recordLog(credential, "SSO_MODIFY_PASSWORD", "FAILED", new String[0]);
            throw new ModifyPWFailedException(credential.getUsername() + "   modify password failed.");
        }
        this.getCasLog().recordLog(credential, "SSO_MODIFY_PASSWORD", "SUCCESS", new String[0]);
        return this.createHandlerResult((Credential)credential, this.principalFactory.createPrincipal(credential.getUsername()), (List)null);
    }

    protected final HandlerResult authenticateUsernamePasswordInternal_default(UsernamePasswordCredential credential) throws GeneralSecurityException, PreventedException {
        int count;
        String idsql;
        String encodeDefaultPwd;
        String salt;
        String encodepassword;
        PasswordEncoder passwordEncoder;
        String username;
        block12: {
            username = credential.getUsername();
            passwordEncoder = this.getPasswordEncoder();
            encodepassword = null;
            salt = null;
            encodeDefaultPwd = null;
            if (passwordEncoder instanceof TenantPasswordEncoder) {
                try {
                    String saltSQL = "select salt from " + this.tableUsers + " WHERE " + this.fieldUser + " = ? ";
                    salt = (String)this.getJdbcTemplate().queryForObject(saltSQL, String.class, new Object[]{username});
                    credential.setSalt(salt);
                    if (USERPWD_LOGIN_TYPE.equals(credential.getIs_security_ca())) {
                        idsql = credential.getPassword();
                        idsql = idsql.replace("_encrypted", "");
                        idsql = RSAUtils.decryptStringByJs((String)idsql);
                        encodepassword = ((TenantPasswordEncoder)passwordEncoder).encode(salt, idsql, username);
                        break block12;
                    }
                    encodepassword = credential.getPassword();
                }
                catch (Exception var10) {
                    this.logger.error(var10.getMessage(), (Throwable)var10);
                }
            } else {
                encodepassword = passwordEncoder.encode(credential.getPassword());
            }
        }
        String encyptedPassword = encodepassword;
        try {
            count = (Integer)this.getJdbcTemplate().queryForObject(this.sql, Integer.class, new Object[]{username, encyptedPassword});
        }
        catch (DataAccessException var9) {
            this.logger.error(var9.getMessage(), (Throwable)var9);
            throw new PreventedException("SQL exception while executing query for " + username, (Throwable)var9);
        }
        if (count == 0) {
            throw new FailedLoginException(username + " not found with SQL query.");
        }
        idsql = " select tenant_id, user_mobile from pub_tenant_user where user_code=? ";
        Map tenantUser = this.getJdbcTemplate().queryForMap(idsql, new Object[]{username});
        String tenantid = null;
        String userMobile = null;
        if (tenantUser.get("tenant_id") != null) {
            tenantid = (String)tenantUser.get("tenant_id");
        }
        if (tenantUser.get("user_mobile") != null) {
            userMobile = (String)tenantUser.get("user_mobile");
        }
        credential.setTenantid(tenantid);
        credential.setPhoneNum(userMobile);
        String tenantDefaultPwdSQL = "select defaultpwd from pub_defaultpwd where tenant_id=?";
        String defaultPwd = (String)this.getJdbcTemplate().queryForObject(tenantDefaultPwdSQL, String.class, new Object[]{tenantid});
        if (defaultPwd != null) {
            String sha1DefaultPwd = Encodes.encodeHex((byte[])Digests.sha1((byte[])defaultPwd.getBytes()));
            encodeDefaultPwd = passwordEncoder instanceof TenantPasswordEncoder ? ((TenantPasswordEncoder)passwordEncoder).encode(salt, sha1DefaultPwd, username) : passwordEncoder.encode(sha1DefaultPwd);
        }
        if (encyptedPassword != null && encyptedPassword.equals(encodeDefaultPwd)) {
            throw new NeedModifyPWException(username);
        }
        return this.createHandlerResult((Credential)credential, this.principalFactory.createPrincipal(username), (List)null);
    }

    protected final HandlerResult authenticateUsernamePasswordInternal_weixin(UsernamePasswordCredential credential) throws GeneralSecurityException, PreventedException {
        String openid = credential.getOpenid();
        String userCode = null;
        String tenant_id = null;
        try {
            String mysql = "select user_code,tenant_id from pub_user_weixin WHERE openid= ? ";
            List list = this.getJdbcTemplate().queryForList(mysql, new Object[]{openid});
            if (list != null && list.size() > 0) {
                userCode = (String)((Map)list.get(0)).get("user_code");
                tenant_id = (String)((Map)list.get(0)).get("tenant_id");
            }
            if (!StringUtils.isEmpty(userCode)) {
                String sql = "select * from pub_tenant_user where user_code= ? ";
                Map result = this.getJdbcTemplate().queryForMap(sql, new Object[]{userCode});
                String user_id = MapUtils.getString((Map)result, (Object)"user_id");
                String user_code = MapUtils.getString((Map)result, (Object)"user_code");
                int type_id = MapUtils.getInteger((Map)result, (Object)"type_id");
                HashMap<String, Object> attr = new HashMap<String, Object>();
                attr.put("userType", type_id);
                attr.put("userId", user_id);
                attr.put("typeAlias", type_id);
                attr.put("userCode", user_code);
                credential.setTenantid(tenant_id);
                credential.setAttrparam(attr);
                this.writeLastLoginDate(user_code);
                return this.createHandlerResult((Credential)credential, this.principalFactory.createPrincipal(userCode), (List)null);
            }
            return null;
        }
        catch (Exception var13) {
            this.logger.error(var13.getMessage(), (Throwable)var13);
            throw new PreventedException("SQL exception while executing query for " + openid, (Throwable)var13);
        }
    }

    private void saveWeixin(UsernamePasswordCredential credential, String user_code) {
        String openid = credential.getOpenid();
        String tenantid = credential.getTenantid();
        if (!StringUtils.isEmpty((String)openid) && !StringUtils.isEmpty((String)user_code)) {
            String mysql = "select user_code from pub_user_weixin WHERE openid= ? ";
            List list = this.getJdbcTemplate().queryForList(mysql, new Object[]{openid});
            String userCode = null;
            if (list != null && list.size() > 0) {
                userCode = (String)((Map)list.get(0)).get("user_code");
            }
            if (StringUtils.isEmpty(userCode)) {
                String addSql = "insert into pub_user_weixin (openid,user_code,tenant_id) value(?,?,?);";
                this.getJdbcTemplate().update(addSql, new Object[]{openid, user_code, tenantid});
            }
        }
    }

    protected final HandlerResult authenticateUsernamePasswordInternal_autoLogin(UsernamePasswordCredential credential) throws GeneralSecurityException, PreventedException {
        String username = credential.getUsername();
        String sql = "select * from pub_tenant_user where user_code= ? ";
        Map result = this.getJdbcTemplate().queryForMap(sql, new Object[]{username});
        String tenant_id = MapUtils.getString((Map)result, (Object)"tenant_id");
        String user_id = MapUtils.getString((Map)result, (Object)"user_id");
        String user_code = MapUtils.getString((Map)result, (Object)"user_code");
        int type_id = MapUtils.getInteger((Map)result, (Object)"type_id");
        HashMap<String, Object> attr = new HashMap<String, Object>();
        attr.put("userType", type_id);
        attr.put("userId", user_id);
        attr.put("typeAlias", type_id);
        attr.put("userCode", user_code);
        credential.setTenantid(tenant_id);
        credential.setAttrparam(attr);
        this.writeLastLoginDate(user_code);
        return this.createHandlerResult((Credential)credential, this.principalFactory.createPrincipal(username), (List)null);
    }

    public void afterPropertiesSet() throws Exception {
        this.sql = SQL_PREFIX + this.tableUsers + " WHERE " + this.fieldUser + " = ? AND " + this.fieldPassword + " = ?";
    }

    public final void setFieldPassword(String fieldPassword) {
        this.fieldPassword = fieldPassword;
    }

    public final void setFieldUser(String fieldUser) {
        this.fieldUser = fieldUser;
    }

    public final void setTableUsers(String tableUsers) {
        this.tableUsers = tableUsers;
    }

    private void writeLastLoginDate(String userCode) {
        if (!StringUtils.isEmpty((String)userCode)) {
            String updateSql = "update pub_tenant_user set last_login_date =? where user_code=?;";
            this.getJdbcTemplate().update(updateSql, new Object[]{DateUtils.getCurrectTime(), userCode});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AuthResult auth(JitGatewayUtilBean jitGatewayUtilBean) {
        AuthResult authResult = new AuthResult();
        boolean isSuccess = true;
        String errCode = null;
        String errDesc = null;
        String original_data_base64 = null;
        String authURL = jitGatewayUtilBean.getAuthURL();
        String appId = CaConfig.appId;
        if (!JitGatewayUtil.isNotNull((String)appId) || !JitGatewayUtil.isNotNull((String)authURL)) {
            isSuccess = false;
            errDesc = "\u5e94\u7528\u6807\u8bc6\u6216\u7f51\u5173\u8ba4\u8bc1\u5730\u5740\u4e0d\u53ef\u4e3a\u7a7a";
            this.logger.info("\u5e94\u7528\u6807\u8bc6\u6216\u7f51\u5173\u8ba4\u8bc1\u5730\u5740\u4e0d\u53ef\u4e3a\u7a7a\n");
        }
        this.logger.info("\u5e94\u7528\u6807\u8bc6\u53ca\u7f51\u5173\u7684\u8ba4\u8bc1\u5730\u5740\u8bfb\u53d6\u6210\u529f\uff01\n\u5e94\u7528\u6807\u8bc6\uff1a" + appId + "\n\u8ba4\u8bc1\u5730\u5740\uff1a" + authURL + "\n");
        if (isSuccess && !"qrcode".equalsIgnoreCase(jitGatewayUtilBean.getAuthMode())) {
            this.logger.info("\u670d\u52a1\u7aef\u9a8c\u8bc1\u8ba4\u8bc1\u539f\u6587\u5f00\u59cb");
            if (JitGatewayUtil.isNotNull((String)jitGatewayUtilBean.getOriginal_data()) && JitGatewayUtil.isNotNull((String)jitGatewayUtilBean.getSigned_data()) && JitGatewayUtil.isNotNull((String)jitGatewayUtilBean.getOriginal_jsp())) {
                if (!jitGatewayUtilBean.getOriginal_data().equalsIgnoreCase(jitGatewayUtilBean.getOriginal_jsp())) {
                    isSuccess = false;
                    errDesc = "\u670d\u52a1\u7aef\u9a8c\u8bc1\u8ba4\u8bc1\u539f\u6587\u5931\u8d25:\u5ba2\u6237\u7aef\u63d0\u4f9b\u7684\u8ba4\u8bc1\u539f\u6587\u4e0e\u670d\u52a1\u7aef\u7684\u4e0d\u4e00\u81f4";
                    this.logger.info(errDesc);
                } else {
                    original_data_base64 = new BASE64Encoder().encode(jitGatewayUtilBean.getOriginal_jsp().getBytes());
                    this.logger.info("\u670d\u52a1\u7aef\u9a8c\u8bc1\u8ba4\u8bc1\u539f\u6587:\u670d\u52a1\u7aef\u9a8c\u8bc1\u8ba4\u8bc1\u539f\u6587\u6210\u529f\uff01\n\u8ba4\u8bc1\u539f\u6587\uff1a" + jitGatewayUtilBean.getOriginal_jsp() + "\n\u8ba4\u8bc1\u8bf7\u6c42\u5305\uff1a" + jitGatewayUtilBean.getSigned_data() + "\n");
                }
            } else {
                isSuccess = false;
                errDesc = "\u670d\u52a1\u7aef\u9a8c\u8bc1\u8ba4\u8bc1\u539f\u6587\u5931\u8d25:\u8bc1\u4e66\u8ba4\u8bc1\u6570\u636e\u4e0d\u5b8c\u6574";
                this.logger.info("\u670d\u52a1\u7aef\u9a8c\u8bc1\u8ba4\u8bc1\u539f\u6587\u5931\u8d25:\u8bc1\u4e66\u8ba4\u8bc1\u6570\u636e\u4e0d\u5b8c\u6574\uff01\n");
            }
            this.logger.info("\u670d\u52a1\u7aef\u9a8c\u8bc1\u8ba4\u8bc1\u539f\u6587\u7ed3\u675f");
        }
        try {
            byte[] messagexml = null;
            if (isSuccess) {
                this.logger.info("\u7ec4\u88c5\u8ba4\u8bc1\u8bf7\u6c42\u62a5\u6587\u5f00\u59cb");
                Document reqDocument = DocumentHelper.createDocument();
                Element root = reqDocument.addElement("message");
                Element requestHeadElement = root.addElement("head");
                Element requestBodyElement = root.addElement("body");
                if (QR_LOGIN_TYPE.equals(CaConfig.randomFrom)) {
                    requestHeadElement.addElement("version").setText("1.1");
                } else {
                    requestHeadElement.addElement("version").setText("1.0");
                }
                requestHeadElement.addElement("serviceType").setText("AuthenService");
                Element clientInfoElement = requestBodyElement.addElement("clientInfo");
                Element clientIPElement = clientInfoElement.addElement("clientIP");
                clientIPElement.setText(jitGatewayUtilBean.getRemoteAddr());
                requestBodyElement.addElement("appId").setText(appId);
                Element authenElement = requestBodyElement.addElement("authen");
                Element authCredentialElement = authenElement.addElement("authCredential");
                if ("cert".equalsIgnoreCase(jitGatewayUtilBean.getAuthMode())) {
                    authCredentialElement.addAttribute("authMode", "cert");
                    authCredentialElement.addElement("detach").setText(jitGatewayUtilBean.getSigned_data());
                    authCredentialElement.addElement("original").setText(original_data_base64);
                } else if ("qrcode".equalsIgnoreCase(jitGatewayUtilBean.getAuthMode())) {
                    authCredentialElement.addAttribute("authMode", "qrcode");
                    authCredentialElement.addElement("token").setText(jitGatewayUtilBean.getToken());
                    authCredentialElement.addElement("QRCode").setText(jitGatewayUtilBean.getQrcode());
                }
                requestBodyElement.addElement("accessControl").setText(String.valueOf(CaConfig.accessControl));
                Element attributesElement = requestBodyElement.addElement("attributes");
                attributesElement.addAttribute("attributeType", "all");
                StringBuffer reqMessageData = new StringBuffer();
                try {
                    ByteArrayOutputStream outStream = new ByteArrayOutputStream();
                    XMLWriter writer = new XMLWriter((OutputStream)outStream);
                    writer.write(reqDocument);
                    messagexml = outStream.toByteArray();
                    reqMessageData.append("\u8bf7\u6c42\u5185\u5bb9\u5f00\u59cb\uff01\n");
                    reqMessageData.append(outStream.toString() + "\n");
                    reqMessageData.append("\u8bf7\u6c42\u5185\u5bb9\u7ed3\u675f\uff01\n");
                    this.logger.info(reqMessageData.toString() + "\n");
                }
                catch (Exception e) {
                    isSuccess = false;
                    errDesc = "\u7ec4\u88c5\u8ba4\u8bc1\u8bf7\u6c42\u62a5\u6587\u51fa\u73b0\u5f02\u5e38";
                    this.logger.info("\u7ec4\u88c5\u8ba4\u8bc1\u8bf7\u6c42\u62a5\u6587\u51fa\u73b0\u5f02\u5e38" + e.getMessage());
                }
                this.logger.info("\u7ec4\u88c5\u8ba4\u8bc1\u8bf7\u6c42\u62a5\u6587\u7ed3\u675f");
            }
            int statusCode = 500;
            HttpClient httpClient = null;
            PostMethod postMethod = null;
            if (isSuccess) {
                this.logger.info("\u5411\u7f51\u5173\u53d1\u9001\u8ba4\u8bc1\u8bf7\u6c42\u5f00\u59cb");
                httpClient = new HttpClient();
                postMethod = new PostMethod(authURL);
                postMethod.setRequestHeader("Connection", "close");
                postMethod.setRequestHeader("Content-Type", "text/xml;charset=UTF-8");
                postMethod.setRequestBody((InputStream)new ByteArrayInputStream(messagexml));
                try {
                    URL url = JitGatewayUtil.protocol((String)authURL);
                    statusCode = httpClient.executeMethod((HttpMethod)postMethod);
                    if (url != null && "https".equals(url.getProtocol())) {
                        Protocol.unregisterProtocol((String)"https");
                    }
                }
                catch (Exception e) {
                    isSuccess = false;
                    errCode = String.valueOf(statusCode);
                    errDesc = e.getMessage();
                    this.logger.info("\u5411\u7f51\u5173\u53d1\u9001\u8ba4\u8bc1\u8bf7\u6c42\u5931\u8d25\uff1a\u4e0e\u7f51\u5173\u8fde\u63a5\u51fa\u73b0\u5f02\u5e38:" + errDesc);
                    postMethod.releaseConnection();
                    httpClient.getHttpConnectionManager().closeIdleConnections(0L);
                    httpClient = null;
                    String errorJdkMess = JitGatewayUtil.errorJdkMess((Exception)e);
                    if (errorJdkMess != null) {
                        errDesc = errorJdkMess;
                    }
                    throw e;
                }
                this.logger.info("\u5411\u7f51\u5173\u53d1\u9001\u8ba4\u8bc1\u8bf7\u6c42\u7ed3\u675f");
            }
            StringBuffer respMessageData = new StringBuffer();
            String respMessageXml = null;
            if (isSuccess) {
                this.logger.info("\u8bfb\u53d6\u7f51\u5173\u8fd4\u56de\u7684\u8ba4\u8bc1\u54cd\u5e94\u62a5\u6587\u5f00\u59cb");
                if (statusCode == 200 || statusCode == 500) {
                    try {
                        byte[] inputstr = postMethod.getResponseBody();
                        ByteArrayInputStream ByteinputStream = new ByteArrayInputStream(inputstr);
                        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
                        int ch = 0;
                        try {
                            while ((ch = ByteinputStream.read()) != -1) {
                                char upperCh = (char)ch;
                                outStream.write(upperCh);
                            }
                        }
                        catch (Exception e) {
                            isSuccess = false;
                            errDesc = e.getMessage();
                        }
                        if (isSuccess) {
                            if (statusCode == 200) {
                                respMessageData.append("\u54cd\u5e94\u5185\u5bb9\u5f00\u59cb\uff01\n");
                                respMessageData.append(new String(outStream.toByteArray(), "UTF-8") + "\n");
                                respMessageData.append("\u54cd\u5e94\u5185\u5bb9\u7ed3\u675f\uff01\n");
                                respMessageXml = new String(outStream.toByteArray(), "UTF-8");
                            } else {
                                respMessageData.append("\u54cd\u5e94500\u5185\u5bb9\u5f00\u59cb\uff01\n");
                                respMessageData.append(new String(outStream.toByteArray()) + "\n");
                                respMessageData.append("\u54cd\u5e94500\u5185\u5bb9\u7ed3\u675f\uff01\n");
                                isSuccess = false;
                                errCode = String.valueOf(statusCode);
                                errDesc = new String(outStream.toByteArray());
                            }
                            this.logger.info(respMessageData.toString());
                        }
                    }
                    catch (IOException e) {
                        isSuccess = false;
                        errCode = String.valueOf(statusCode);
                        errDesc = e.getMessage();
                        this.logger.info("\u8bfb\u53d6\u7f51\u5173\u8fd4\u56de\u7684\u8ba4\u8bc1\u54cd\u5e94\u62a5\u6587\u51fa\u73b0\u5f02\u5e38:" + errDesc);
                    }
                    finally {
                        if (httpClient != null) {
                            postMethod.releaseConnection();
                            httpClient.getHttpConnectionManager().closeIdleConnections(0L);
                        }
                    }
                }
                this.logger.info("\u8bfb\u53d6\u7f51\u5173\u8fd4\u56de\u7684\u8ba4\u8bc1\u54cd\u5e94\u62a5\u6587\u7ed3\u675f");
            }
            Document respDocument = null;
            Element headElement = null;
            Element bodyElement = null;
            if (isSuccess) {
                boolean state;
                this.logger.info("\u89e3\u6790\u7f51\u5173\u8fd4\u56de\u7684\u8ba4\u8bc1\u54cd\u5e94\u62a5\u6587\u5f00\u59cb");
                respMessageXml = respMessageXml.replaceAll("&", "&amp;");
                respDocument = DocumentHelper.parseText((String)respMessageXml);
                headElement = respDocument.getRootElement().element("head");
                bodyElement = respDocument.getRootElement().element("body");
                if (headElement != null && (state = Boolean.valueOf(headElement.elementTextTrim("messageState")).booleanValue())) {
                    isSuccess = false;
                    errCode = headElement.elementTextTrim("messageCode");
                    errDesc = headElement.elementTextTrim("messageDesc");
                    this.logger.info("\u7f51\u5173\u8ba4\u8bc1\u4e1a\u52a1\u5904\u7406\u5931\u8d25\uff01\t" + errDesc + "\n");
                }
            }
            if (isSuccess) {
                this.logger.info("\u89e3\u6790\u62a5\u6587\u5934\u6210\u529f\uff01\n");
                Element authResultElement = bodyElement.element("authResultSet").element("authResult");
                isSuccess = Boolean.valueOf(authResultElement.attributeValue("success"));
                if (!isSuccess) {
                    errCode = authResultElement.elementTextTrim("authMessageCode");
                    errDesc = authResultElement.elementTextTrim("authMessageDesc");
                    this.logger.info("\u8eab\u4efd\u8ba4\u8bc1\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + errDesc);
                }
            }
            if (isSuccess) {
                this.logger.info("\u8eab\u4efd\u8ba4\u8bc1\u6210\u529f\uff01\n");
                String accessControlResult = bodyElement.elementTextTrim("accessControlResult");
                this.logger.info("\u7f51\u5173\u6839\u636e\u89c4\u5219\u5bf9\u8be5\u7528\u6237\u8ba1\u7b97\u7684\u8bbf\u95ee\u63a7\u5236\u7ed3\u679c:" + accessControlResult);
                authResult.setAccessControlResult(accessControlResult);
                if ("Deny".equals(accessControlResult)) {
                    isSuccess = false;
                    errCode = "-1";
                    errDesc = "\u8be5\u7528\u6237\u65e0\u6743\u9650\u8bbf\u95ee\u6b64\u5e94\u7528";
                } else {
                    List namespacesElements;
                    Element attrsElement = bodyElement.element("attributes");
                    if (attrsElement != null && (namespacesElements = attrsElement.elements("attr")) != null && namespacesElements.size() > 0) {
                        this.logger.info("\u5c5e\u6027\u4e2a\u6570\uff1a" + namespacesElements.size());
                        for (int i = 0; i < namespacesElements.size(); ++i) {
                            String arrs = ((Element)namespacesElements.get(i)).attributeValue("namespace");
                            this.logger.info(arrs);
                        }
                        HashMap<Object, String> certAttributeNodeMap = new HashMap<Object, String>();
                        HashMap<String[], String> childAttributeNodeMap = new HashMap<String[], String>();
                        HashMap<String[], String> umsAttributeNodeMap = new HashMap<String[], String>();
                        HashMap<String[], String> pmsAttributeNodeMap = new HashMap<String[], String>();
                        HashMap<String[], String> customAttributeNodeMap = new HashMap<String[], String>();
                        String[] keys = new String[2];
                        if (attrsElement != null) {
                            List attributeNodeList = attrsElement.elements("attr");
                            for (int i = 0; i < attributeNodeList.size(); ++i) {
                                keys = new String[2];
                                Element userAttrNode = (Element)attributeNodeList.get(i);
                                String msgParentName = userAttrNode.attributeValue("parentName");
                                String name = userAttrNode.attributeValue("name");
                                String value = userAttrNode.getTextTrim();
                                keys[0] = name;
                                childAttributeNodeMap.clear();
                                String arrs = ((Element)namespacesElements.get(i)).attributeValue("namespace");
                                if (arrs.trim().equals("http://www.jit.com.cn/cinas/ias/ns/saml/saml11/X.509")) {
                                    if (msgParentName != null && !msgParentName.equals("")) {
                                        keys[1] = msgParentName;
                                        if (value != null && value.length() > 0) {
                                            childAttributeNodeMap.put(keys, value);
                                        }
                                    } else if (value != null && value.length() > 0) {
                                        certAttributeNodeMap.put(keys, value);
                                        if (name.endsWith("X509Certificate.SubjectDN")) {
                                            authResult.setSubjectDN(value);
                                        }
                                    }
                                    certAttributeNodeMap.putAll(childAttributeNodeMap);
                                    continue;
                                }
                                if (arrs.trim().equals("http://www.jit.com.cn/ums/ns/user")) {
                                    if (msgParentName != null && !msgParentName.equals("")) {
                                        keys[1] = msgParentName;
                                        if (value != null && value.length() > 0) {
                                            childAttributeNodeMap.put(keys, value);
                                        }
                                    } else if (value != null && value.length() > 0) {
                                        umsAttributeNodeMap.put(keys, value);
                                    }
                                    umsAttributeNodeMap.putAll(childAttributeNodeMap);
                                    continue;
                                }
                                if (arrs.trim().indexOf("http://www.jit.com.cn/pmi/pms") != -1) {
                                    if (msgParentName != null && !msgParentName.equals("")) {
                                        keys[1] = msgParentName;
                                        if (value != null && value.length() > 0) {
                                            childAttributeNodeMap.put(keys, value);
                                        }
                                    } else if (value != null && value.length() > 0) {
                                        pmsAttributeNodeMap.put(keys, value);
                                    }
                                    pmsAttributeNodeMap.putAll(childAttributeNodeMap);
                                    continue;
                                }
                                if (arrs.trim().indexOf("http://www.jit.com.cn/gw/custom/attribute") != -1) {
                                    if (msgParentName != null && !msgParentName.equals("")) {
                                        keys[1] = msgParentName;
                                        if (value != null && value.length() > 0) {
                                            childAttributeNodeMap.put(keys, value);
                                        }
                                    } else if (value != null && value.length() > 0) {
                                        customAttributeNodeMap.put(keys, value);
                                    }
                                    customAttributeNodeMap.putAll(childAttributeNodeMap);
                                    continue;
                                }
                                if (msgParentName != null && !msgParentName.equals("")) {
                                    keys[1] = msgParentName;
                                    if (value != null && value.length() > 0) {
                                        childAttributeNodeMap.put(keys, value);
                                    }
                                } else if (value != null && value.length() > 0) {
                                    certAttributeNodeMap.put(keys, value);
                                }
                                certAttributeNodeMap.putAll(childAttributeNodeMap);
                            }
                            authResult.setCertAttributeNodeMap(certAttributeNodeMap);
                            authResult.setUmsAttributeNodeMap(umsAttributeNodeMap);
                            authResult.setPmsAttributeNodeMap(pmsAttributeNodeMap);
                            authResult.setCustomAttributeNodeMap(customAttributeNodeMap);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            isSuccess = false;
            e.printStackTrace();
            errDesc = e.getMessage();
        }
        this.logger.info("\u89e3\u6790\u7f51\u5173\u8fd4\u56de\u7684\u8ba4\u8bc1\u54cd\u5e94\u62a5\u6587\u7ed3\u675f");
        authResult.setSuccess(isSuccess);
        authResult.setErrCode(errCode);
        authResult.setErrDesc(errDesc);
        return authResult;
    }
}

