/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.uap.tenant.utils;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.validation.constraints.NotNull;
import org.jasig.cas.authentication.handler.PasswordEncoder;
import org.springframework.util.StringUtils;
import org.springside.modules.security.utils.Digests;
import org.springside.modules.utils.Encodes;

public class TenantPasswordEncoder
implements PasswordEncoder {
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final int HEX_RIGHT_SHIFT_COEFFICIENT = 4;
    public static final int HASH_INTERATIONS = 1;
    @NotNull
    private final String encodingAlgorithm;
    private String characterEncoding;

    public TenantPasswordEncoder(String encodingAlgorithm) {
        this.encodingAlgorithm = encodingAlgorithm;
    }

    public String encode(String password) {
        return this.defaultEncode(password);
    }

    public String encode(String salt, String password) {
        if (password == null) {
            return null;
        }
        if ("SHA1-SALT".equalsIgnoreCase(this.encodingAlgorithm)) {
            byte[] hashPassword = Digests.sha1((byte[])password.getBytes(), (byte[])Encodes.decodeHex((String)salt), (int)1);
            return Encodes.encodeHex((byte[])hashPassword);
        }
        return this.defaultEncode(password);
    }

    public String encode(String salt, String password, String userCode) {
        if (password == null) {
            return null;
        }
        if ("SHA1-SALT".equalsIgnoreCase(this.encodingAlgorithm)) {
            String hashUserCode = this.encodePasswordUsingSHA(userCode);
            byte[] hashPassword = Digests.sha1((byte[])(password + hashUserCode).getBytes(), (byte[])Encodes.decodeHex((String)salt), (int)1);
            return Encodes.encodeHex((byte[])hashPassword);
        }
        return this.defaultEncode(password);
    }

    private String encodePasswordUsingSHA(String password) {
        byte[] hashPassword = Digests.sha1((byte[])password.getBytes());
        String result = Encodes.encodeHex((byte[])hashPassword);
        return result;
    }

    private String defaultEncode(String password) {
        if (password == null) {
            return null;
        }
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(this.encodingAlgorithm);
            if (StringUtils.hasText((String)this.characterEncoding)) {
                messageDigest.update(password.getBytes(this.characterEncoding));
            } else {
                messageDigest.update(password.getBytes(Charset.defaultCharset()));
            }
            byte[] digest = messageDigest.digest();
            return this.getFormattedText(digest);
        }
        catch (NoSuchAlgorithmException e) {
            throw new SecurityException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new SecurityException(e.getMessage(), e);
        }
    }

    private String getFormattedText(byte[] bytes) {
        StringBuilder buf = new StringBuilder(bytes.length * 2);
        for (int j = 0; j < bytes.length; ++j) {
            buf.append(HEX_DIGITS[bytes[j] >> 4 & 0xF]);
            buf.append(HEX_DIGITS[bytes[j] & 0xF]);
        }
        return buf.toString();
    }

    public void setCharacterEncoding(String characterEncoding) {
        this.characterEncoding = characterEncoding;
    }
}

