/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.uap.tenant.web.filter.security;

import com.yonyou.iuap.security.rest.common.SignProp;
import com.yonyou.iuap.security.rest.exception.UAPSecurityException;
import com.yonyou.iuap.security.rest.utils.PostParamsHelper;
import com.yonyou.iuap.security.rest.utils.SignPropGenerator;
import com.yonyou.uap.tenant.web.filter.security.SSORestFulSecurityFilter;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSORestFulSecurityFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(SSORestFulSecurityFilter.class);
    private static final long DEFAULT_EXPIRED = 300000L;

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest) {
            boolean passed;
            HttpServletRequest httpReq = (HttpServletRequest)request;
            String sign = httpReq.getHeader("sign");
            String appid = httpReq.getHeader("appId");
            if (StringUtils.isEmpty((String)sign)) {
                sign = httpReq.getParameter("sign");
            }
            if (StringUtils.isEmpty((String)appid)) {
                appid = httpReq.getParameter("appId");
            }
            if (sign == null || appid == null) {
                HttpServletResponse rp = (HttpServletResponse)response;
                rp.setStatus(400);
                rp.addHeader("restful validate error", " 400 , Method Not Allowed,please check restful called paramters ! ");
                rp.getWriter().write("Method Not Allowed,please check restful called paramters !");
                return;
            }
            String ts = httpReq.getParameter("ts");
            if (StringUtils.isNumeric((String)ts)) {
                long sendTs = Long.parseLong(ts);
                if (System.currentTimeMillis() - sendTs > 300000L) {
                    HttpServletResponse rp = (HttpServletResponse)response;
                    rp.setStatus(400);
                    rp.addHeader("restful validate error", " 400 , \u8bf7\u6c42\u8d85\u65f6");
                    logger.error("restful \u7b7e\u540d\u8d85\u8d85\u65f6");
                    rp.getWriter().write("restful validate over time");
                    return;
                }
            }
            if (!(passed = this.validatorURL(httpReq).booleanValue())) {
                HttpServletResponse rp = (HttpServletResponse)response;
                rp.setStatus(400);
                rp.addHeader("restful validate error", " 400 , Method Not Allowed,please check restful called paramters ! ");
                rp.getWriter().write("Method Not Allowed,please check restful called paramters !");
                return;
            }
        }
        filterChain.doFilter(request, response);
    }

    public void destroy() {
    }

    public Boolean validatorURL(HttpServletRequest httpReq) {
        String sign = httpReq.getHeader("sign");
        if (StringUtils.isEmpty((String)sign)) {
            sign = httpReq.getParameter("sign");
        }
        String appid = httpReq.getParameter("appId");
        sign = StringUtils.isEmpty((String)sign) ? httpReq.getHeader("sign") : sign;
        String string = appid = StringUtils.isEmpty((String)appid) ? httpReq.getHeader("appId") : appid;
        if (StringUtils.isNotEmpty((String)sign) && StringUtils.isNotEmpty((String)appid)) {
            try {
                String url = httpReq.getRequestURL().toString();
                if (StringUtils.isNotBlank((String)httpReq.getQueryString())) {
                    url = url + "?" + httpReq.getQueryString();
                }
                SignProp prop = SignPropGenerator.genSignProp((String)url);
                if (httpReq.getMethod().endsWith("POST")) {
                    prop.setPostParamsStr(PostParamsHelper.genParamsStrByReqeust((HttpServletRequest)httpReq));
                    prop.setContentLength((long)httpReq.getContentLength());
                }
                RestServerVirifyFactory factory = new RestServerVirifyFactory(this);
                return factory.getVerifier(appid).verify(sign, prop);
            }
            catch (UAPSecurityException e) {
                logger.error("restful\u6458\u8981\u8ba1\u7b97\u5931\u8d25!", (Throwable)e);
            }
            catch (Exception e) {
                logger.error("restful\u6458\u8981\u8ba1\u7b97\u5931\u8d25!", (Throwable)e);
            }
        }
        return Boolean.FALSE;
    }
}

