/*
 * Decompiled with CFR 0.152.
 */
package com.yonyouccs.cinas;

import com.yonyouccs.config.CaConfig;
import com.yonyouccs.gateway.util.JitGatewayUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.URL;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.XMLWriter;
import uap.web.cache.CacheManager;
import uap.web.core.ContextHolder;

public class RandomServlet
extends HttpServlet {
    private static final long serialVersionUID = 7686671397537106958L;
    private static final Log logger = LogFactory.getLog(RandomServlet.class);
    CaConfig caConfig = new CaConfig();

    public void init(ServletConfig cfg) throws ServletException {
        logger.info((Object)"\u751f\u6210\u539f\u6587\u521d\u59cb\u5316\u5f00\u59cb");
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        JitGatewayUtil jitGatewayUtil = new JitGatewayUtil();
        HttpServletRequest request = req;
        HttpServletResponse response = resp;
        String randNum = null;
        if (!CaConfig.QRCodeAuth) {
            logger.info((Object)"\u751f\u6210\u539f\u6587\u5f00\u59cb");
            response.setHeader("Pragma", "No-cache");
            response.setHeader("Cache-Control", "no-cache");
            response.setDateHeader("Expires", 0L);
            randNum = this.generateRandomNum();
            if (!JitGatewayUtil.isNotNull((String)randNum)) {
                logger.info((Object)"\u751f\u6210\u539f\u6587\u4e3a\u7a7a\uff01");
                response.setStatus(500);
                return;
            }
            CacheManager cacheManager = (CacheManager)ContextHolder.getContext().getBean("cacheManager");
            cacheManager.setex("original_data", (Serializable)((Object)randNum), 600);
            logger.info((Object)("\u751f\u6210\u539f\u6587\u7ed3\u675f\uff0c\u6210\u529f\u751f\u6210\u539f\u6587\uff1a" + randNum));
        }
        response.setContentType("application/x-json");
        PrintWriter out = response.getWriter();
        out.write("{\"original_data\":\"" + randNum + "\",\"QRCodeAuth\":\"" + CaConfig.QRCodeAuth + "\",\"original\":\"" + randNum + "\"}");
        out.flush();
        out.close();
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        this.doGet(req, resp);
    }

    private String generateRandomNum() {
        String random = "";
        if ("2".equals(CaConfig.randomFrom)) {
            logger.info((Object)"\u8c03\u7528\u7f51\u5173\u751f\u6210\u539f\u6587");
            random = this.generateRandomNumFromGagewayServer();
        } else {
            logger.info((Object)"\u8c03\u7528\u5e94\u7528\u670d\u52a1\u5668\u751f\u6210\u539f\u6587");
            random = this.generateRandomNumByApplication();
        }
        logger.info((Object)("\u751f\u6210\u539f\u6587\u7ed3\u675f\uff0c\u539f\u6587\uff1a" + random));
        return random;
    }

    private String generateRandomNumByApplication() {
        String num = "1234567890abcdefghijklmnopqrstopqrstuvwxyz";
        int size = 6;
        char[] charArray = num.toCharArray();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < size; ++i) {
            sb.append(charArray[(int)(Math.random() * 10000.0) % charArray.length]);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String generateRandomNumFromGagewayServer() {
        boolean state;
        String errCode = null;
        String errDesc = null;
        byte[] messagexml = null;
        logger.info((Object)"\u7ec4\u88c5\u8ba4\u8bc1\u539f\u6587\u8bf7\u6c42\u62a5\u6587\u6570\u636e\u5f00\u59cb");
        Document reqDocument = DocumentHelper.createDocument();
        Element root = reqDocument.addElement("message");
        Element requestHeadElement = root.addElement("head");
        Element requestBodyElement = root.addElement("body");
        requestHeadElement.addElement("version").setText("1.0");
        requestHeadElement.addElement("serviceType").setText("OriginalService");
        requestBodyElement.addElement("appId").setText(CaConfig.appId);
        StringBuffer reqMessageData = new StringBuffer();
        try {
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            XMLWriter writer = new XMLWriter((OutputStream)outStream);
            writer.write(reqDocument);
            messagexml = outStream.toByteArray();
            reqMessageData.append("\u8bf7\u6c42\u5185\u5bb9\u5f00\u59cb\uff01\n");
            reqMessageData.append(outStream.toString() + "\n");
            reqMessageData.append("\u8bf7\u6c42\u5185\u5bb9\u7ed3\u675f\uff01\n");
            logger.info((Object)(reqMessageData.toString() + "\n"));
        }
        catch (Exception e) {
            errDesc = "\u7ec4\u88c5\u539f\u6587\u8bf7\u6c42\u62a5\u6587\u65f6\u51fa\u73b0\u5f02\u5e38";
            logger.info((Object)("\u7ec4\u88c5\u539f\u6587\u8bf7\u6c42\u62a5\u6587\u65f6\u51fa\u73b0\u5f02\u5e38" + e.getMessage()));
        }
        logger.info((Object)"\u7ec4\u88c5\u8ba4\u8bc1\u539f\u6587\u8bf7\u6c42\u62a5\u6587\u6570\u636e\u7ed3\u675f");
        logger.info((Object)"\u521b\u5efa\u4e0e\u7f51\u5173\u7684HTTP\u8fde\u63a5\uff0c\u53d1\u9001\u8ba4\u8bc1\u539f\u6587\u8bf7\u6c42\u62a5\u6587\u5f00\u59cb");
        String authURL = CaConfig.authURL;
        int statusCode = 500;
        HttpClient httpClient = new HttpClient();
        PostMethod postMethod = new PostMethod(authURL);
        postMethod.setRequestHeader("Connection", "close");
        postMethod.setRequestHeader("Content-Type", "text/xml;charset=UTF-8");
        postMethod.setRequestBody((InputStream)new ByteArrayInputStream(messagexml));
        try {
            URL url = JitGatewayUtil.protocol((String)authURL);
            statusCode = httpClient.executeMethod((HttpMethod)postMethod);
            if (url != null && "https".equals(url.getProtocol())) {
                Protocol.unregisterProtocol((String)"https");
            }
        }
        catch (Exception e) {
            errCode = String.valueOf(statusCode);
            errDesc = e.getMessage();
            logger.info((Object)("\u53d1\u9001\u539f\u6587\u8bf7\u6c42\u62a5\u6587\u4e0e\u7f51\u5173\u8fde\u63a5\u51fa\u73b0\u5f02\u5e38\uff1a" + errDesc));
            postMethod.releaseConnection();
            httpClient.getHttpConnectionManager().closeIdleConnections(0L);
            httpClient = null;
            String errorJdkMess = JitGatewayUtil.errorJdkMess((Exception)e);
            if (errorJdkMess != null) {
                errDesc = errorJdkMess;
            }
            e.printStackTrace();
            return null;
        }
        logger.info((Object)"\u521b\u5efa\u4e0e\u7f51\u5173\u7684HTTP\u8fde\u63a5\uff0c\u53d1\u9001\u8ba4\u8bc1\u539f\u6587\u8bf7\u6c42\u62a5\u6587\u7ed3\u675f");
        StringBuffer respMessageData = new StringBuffer();
        String respMessageXml = null;
        if (statusCode == 200 || statusCode == 500) {
            try {
                byte[] inputstr = postMethod.getResponseBody();
                ByteArrayInputStream byteinputStream = new ByteArrayInputStream(inputstr);
                ByteArrayOutputStream outStream = new ByteArrayOutputStream();
                int ch = 0;
                try {
                    while ((ch = byteinputStream.read()) != -1) {
                        char upperCh = (char)ch;
                        outStream.write(upperCh);
                    }
                }
                catch (Exception e) {
                    errDesc = e.getMessage();
                }
                if (statusCode == 200) {
                    respMessageData.append("\u54cd\u5e94\u5185\u5bb9\u5f00\u59cb\uff01\n");
                    respMessageData.append(new String(outStream.toByteArray(), "UTF-8") + "\n");
                    respMessageData.append("\u54cd\u5e94\u5185\u5bb9\u5f00\u59cb\uff01\n");
                    respMessageXml = new String(outStream.toByteArray(), "UTF-8");
                } else {
                    respMessageData.append("\u54cd\u5e94500\u5185\u5bb9\u5f00\u59cb\uff01\n");
                    respMessageData.append(new String(outStream.toByteArray()) + "\n");
                    respMessageData.append("\u54cd\u5e94500\u5185\u5bb9\u7ed3\u675f\uff01\n");
                    errCode = String.valueOf(statusCode);
                    errDesc = new String(outStream.toByteArray());
                }
                logger.info((Object)("\u7f51\u5173\u8fd4\u56de\u54cd\u5e94\u5185\u5bb9\uff1a" + respMessageData.toString()));
            }
            catch (IOException e) {
                errCode = String.valueOf(statusCode);
                errDesc = e.getMessage();
                logger.info((Object)("\u8bfb\u53d6\u539f\u6587\u8bf7\u6c42\u54cd\u5e94\u62a5\u6587\u51fa\u73b0\u5f02\u5e38\uff1a" + errCode + "," + errDesc));
            }
            finally {
                if (httpClient != null) {
                    postMethod.releaseConnection();
                    httpClient.getHttpConnectionManager().closeIdleConnections(0L);
                }
            }
        }
        Document respDocument = null;
        Element headElement = null;
        Element bodyElement = null;
        logger.info((Object)"\u89e3\u6790\u7f51\u5173\u670d\u52a1\u5668\u8fd4\u56de\u7684\u539f\u6587\u8bf7\u6c42\u54cd\u5e94\u62a5\u6587\u5f00\u59cb");
        try {
            respDocument = DocumentHelper.parseText(respMessageXml);
        }
        catch (DocumentException e) {
            logger.info((Object)("\u89e3\u6790\u8ba4\u8bc1\u8fd4\u56de\u4fe1\u606f\u5f02\u5e38\uff1a" + e.getMessage()));
        }
        headElement = respDocument.getRootElement().element("head");
        bodyElement = respDocument.getRootElement().element("body");
        if (headElement != null && (state = Boolean.valueOf(headElement.elementTextTrim("messageState")).booleanValue())) {
            errCode = headElement.elementTextTrim("messageCode");
            errDesc = headElement.elementTextTrim("messageDesc");
            logger.info((Object)("\u5411\u7f51\u5173\u8bf7\u6c42\u539f\u6587\u5931\u8d25\uff1a" + errCode + "," + errDesc));
        }
        Element originalElement = bodyElement.element("original");
        String original = "";
        if (originalElement != null) {
            original = originalElement.getStringValue();
            logger.info((Object)("\u5411\u7f51\u5173\u8bf7\u6c42\u539f\u6587\u6210\u529f\uff0c\u751f\u6210\u539f\u6587\uff1a" + original));
        }
        logger.info((Object)"\u89e3\u6790\u7f51\u5173\u670d\u52a1\u5668\u8fd4\u56de\u7684\u539f\u6587\u8bf7\u6c42\u54cd\u5e94\u62a5\u6587\u7ed3\u675f");
        return original;
    }
}

