/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.support.rest;

import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.Formatter;
import javax.servlet.http.HttpServletRequest;
import org.jasig.cas.CentralAuthenticationService;
import org.jasig.cas.authentication.AuthenticationException;
import org.jasig.cas.authentication.Credential;
import org.jasig.cas.authentication.UsernamePasswordCredential;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.authentication.principal.SimpleWebApplicationServiceImpl;
import org.jasig.cas.ticket.InvalidTicketException;
import org.jasig.cas.ticket.ServiceTicket;
import org.jasig.cas.ticket.TicketException;
import org.jasig.cas.ticket.TicketGrantingTicket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import uap.web.cache.CacheManager;
import uap.web.core.ContextHolder;

@RestController(value="/v1")
public class TicketsResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(TicketsResource.class);
    @Autowired
    private CentralAuthenticationService cas;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RequestMapping(value={"/tickets"}, method={RequestMethod.POST}, consumes={"application/x-www-form-urlencoded"})
    public final ResponseEntity<String> createTicketGrantingTicket(@RequestBody MultiValueMap<String, String> requestBody, HttpServletRequest request) {
        try (Formatter fmt = new Formatter();){
            UsernamePasswordCredential credential = (UsernamePasswordCredential)this.obtainCredential(requestBody);
            TicketGrantingTicket tgtId = this.cas.createTicketGrantingTicket(new Credential[]{credential});
            URI ticketReference = new URI(request.getRequestURL().toString() + '/' + tgtId.getId() + "__" + credential.getAttrparam().get("userId"));
            HttpHeaders headers = new HttpHeaders();
            headers.setLocation(ticketReference);
            headers.setContentType(MediaType.TEXT_HTML);
            fmt.format("<!DOCTYPE HTML PUBLIC \\\"-//IETF//DTD HTML 2.0//EN\\\"><html><head><title>", new Object[0]);
            fmt.format("%s %s", HttpStatus.OK, HttpStatus.OK.getReasonPhrase()).format("</title></head><body><h1>TGT Created</h1><form action=\"%s", ticketReference.toString()).format("\" method=\"POST\">Service:<input type=\"text\" name=\"service\" value=\"\">", new Object[0]).format("<br><input type=\"submit\" value=\"Submit\"></form></body></html>", new Object[0]);
            ResponseEntity responseEntity = new ResponseEntity((Object)fmt.toString(), (MultiValueMap)headers, HttpStatus.OK);
            return responseEntity;
        }
        catch (URISyntaxException | AuthenticationException | TicketException e) {
            LOGGER.error(e.getMessage(), e);
            return new ResponseEntity((Object)e.getMessage(), HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/tickets/{tgtId:.+}"}, method={RequestMethod.POST}, consumes={"application/x-www-form-urlencoded"})
    public final ResponseEntity<String> createServiceTicket(@RequestBody MultiValueMap<String, String> requestBody, @PathVariable(value="tgtId") String tgtId) {
        try {
            ServiceTicket serviceTicketId = this.cas.grantServiceTicket(tgtId, (Service)new SimpleWebApplicationServiceImpl(URLDecoder.decode((String)requestBody.getFirst((Object)"service"), "UTF-8")));
            return new ResponseEntity((Object)serviceTicketId.getId(), HttpStatus.OK);
        }
        catch (InvalidTicketException e) {
            return new ResponseEntity((Object)"TicketGrantingTicket could not be found", HttpStatus.NOT_FOUND);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return new ResponseEntity((Object)e.getMessage(), HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/tickets/{tgtId:.+}"}, method={RequestMethod.DELETE})
    public final ResponseEntity<String> deleteTicketGrantingTicket(@PathVariable(value="tgtId") String tgtId) {
        this.cas.destroyTicketGrantingTicket(tgtId);
        return new ResponseEntity((Object)tgtId, HttpStatus.OK);
    }

    protected Credential obtainCredential(MultiValueMap<String, String> requestBody) {
        String flag = (String)requestBody.getFirst((Object)"isAutoLogin");
        if (flag != null) {
            try {
                int isAutoLogin = Integer.parseInt(flag);
                return new UsernamePasswordCredential((String)requestBody.getFirst((Object)"auto_username"), (String)requestBody.getFirst((Object)"password"), isAutoLogin);
            }
            catch (NumberFormatException e) {
                LOGGER.error("from string to int  exception " + e.getMessage(), (Throwable)e);
            }
        }
        UsernamePasswordCredential credential = new UsernamePasswordCredential((String)requestBody.getFirst((Object)"auto_username"), (String)requestBody.getFirst((Object)"password"));
        CacheManager cacheManager = (CacheManager)ContextHolder.getContext().getBean("cacheManager");
        String randomvaule = String.valueOf(System.currentTimeMillis());
        cacheManager.setex("tmp_sso_random_" + randomvaule, (Serializable)((Object)randomvaule), 600);
        credential.setRandomvalue(randomvaule);
        credential.setVerify_code("usercenter");
        credential.setSysid("icop");
        return credential;
    }
}

