/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.web.flow;

import javax.validation.constraints.NotNull;
import org.jasig.cas.CentralAuthenticationService;
import org.jasig.cas.authentication.AuthenticationException;
import org.jasig.cas.authentication.Credential;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.authentication.principal.WebApplicationService;
import org.jasig.cas.ticket.InvalidTicketException;
import org.jasig.cas.ticket.ServiceTicket;
import org.jasig.cas.ticket.TicketException;
import org.jasig.cas.web.support.WebUtils;
import org.springframework.util.StringUtils;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public final class GenerateServiceTicketAction
extends AbstractAction {
    @NotNull
    private CentralAuthenticationService centralAuthenticationService;

    protected Event doExecute(RequestContext context) {
        block4: {
            WebApplicationService service = WebUtils.getService((RequestContext)context);
            String ticketGrantingTicket = WebUtils.getTicketGrantingTicketId((RequestContext)context);
            try {
                Credential credential = WebUtils.getCredential((RequestContext)context);
                ServiceTicket serviceTicketId = this.centralAuthenticationService.grantServiceTicket(ticketGrantingTicket, (Service)service, new Credential[]{credential});
                WebUtils.putServiceTicketInRequestScope((RequestContext)context, (ServiceTicket)serviceTicketId);
                return this.success();
            }
            catch (AuthenticationException e) {
                this.logger.error((Object)"Could not verify credentials to grant service ticket", (Throwable)e);
            }
            catch (TicketException e) {
                if (e instanceof InvalidTicketException) {
                    this.centralAuthenticationService.destroyTicketGrantingTicket(ticketGrantingTicket);
                }
                if (!this.isGatewayPresent(context)) break block4;
                return this.result("gateway");
            }
        }
        return this.error();
    }

    public void setCentralAuthenticationService(CentralAuthenticationService centralAuthenticationService) {
        this.centralAuthenticationService = centralAuthenticationService;
    }

    protected boolean isGatewayPresent(RequestContext context) {
        return StringUtils.hasText((String)context.getExternalContext().getRequestParameterMap().get("gateway"));
    }
}

