/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.web.flow;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import javax.validation.constraints.NotNull;
import org.jasig.cas.CentralAuthenticationService;
import org.jasig.cas.ticket.Ticket;
import org.jasig.cas.ticket.TicketException;
import org.jasig.cas.ticket.TicketGrantingTicketImpl;
import org.jasig.cas.web.support.WebUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.util.StringUtils;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import uap.web.core.ContextHolder;

public class TicketGrantingTicketCheckAction
extends AbstractAction {
    public static final String NOT_EXISTS = "notExists";
    public static final String INVALID = "invalid";
    public static final String VALID = "valid";
    @NotNull
    private final CentralAuthenticationService centralAuthenticationService;

    public TicketGrantingTicketCheckAction(CentralAuthenticationService centralAuthenticationService) {
        this.centralAuthenticationService = centralAuthenticationService;
    }

    protected Event doExecute(RequestContext requestContext) throws Exception {
        String tgtId = WebUtils.getTicketGrantingTicketId((RequestContext)requestContext);
        if (!StringUtils.hasText((String)tgtId)) {
            return new Event((Object)this, NOT_EXISTS);
        }
        String eventId = INVALID;
        try {
            Ticket ticket = this.centralAuthenticationService.getTicket(tgtId, Ticket.class);
            if (ticket != null && !ticket.isExpired()) {
                Map attributes;
                String sysid = requestContext.getRequestParameters().get("sysid");
                if (sysid == null || sysid.equalsIgnoreCase("")) {
                    eventId = VALID;
                } else if (ticket instanceof TicketGrantingTicketImpl && (attributes = ((TicketGrantingTicketImpl)ticket).getAuthentication().getPrincipal().getAttributes()) != null) {
                    ApplicationContext context = ContextHolder.getContext();
                    JdbcTemplate jdbcTemplate = new JdbcTemplate((DataSource)context.getBean("dataSource"));
                    String tenantId = (String)attributes.get("tenantId");
                    String userId = (String)attributes.get("userId");
                    Object usertypeObject = attributes.get("userType");
                    int userType = -1;
                    if (usertypeObject != null && !usertypeObject.equals("")) {
                        userType = (Integer)attributes.get("userType");
                    }
                    eventId = !StringUtils.isEmpty((Object)tenantId) && !StringUtils.isEmpty((Object)userId) && userType != -1 ? ("tenant".equalsIgnoreCase(sysid) || "tenantuser".equalsIgnoreCase(sysid) || "tenantauth".equalsIgnoreCase(sysid) ? VALID : this.dealAppAuth(jdbcTemplate, tenantId, sysid, userId, userType)) : INVALID;
                }
            }
        }
        catch (TicketException e) {
            this.logger.trace((Object)"Could not retrieve ticket id {} from registry.", (Throwable)e);
        }
        return new Event((Object)this, eventId);
    }

    private boolean after(String date) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Calendar cal = Calendar.getInstance();
        cal.setTime(sdf.parse(date));
        Calendar today = Calendar.getInstance();
        return cal.after(today);
    }

    private String dealAppAuth(JdbcTemplate jdbcTemplate, String tenantId, String sysid, String userId, int userType) {
        String eventId = INVALID;
        String groupSql = "select * from pub_auth_group_res where group_code=?";
        List grouplist = jdbcTemplate.queryForList(groupSql, new Object[]{sysid});
        if (grouplist.size() == 0) {
            eventId = this.dealOneAppAuth(jdbcTemplate, tenantId, sysid, userId, userType);
        } else if (grouplist.size() == 1) {
            Map map = (Map)grouplist.get(0);
            if (map != null) {
                String resCode = (String)map.get("res_code");
                eventId = this.dealOneAppAuth(jdbcTemplate, tenantId, resCode, userId, userType);
            }
        } else if (grouplist.size() > 1) {
            eventId = this.dealMutiAppAuth(grouplist, jdbcTemplate, tenantId, userId, userType);
        }
        return eventId;
    }

    private String dealOneAppAuth(JdbcTemplate jdbcTemplate, String tenantId, String sysid, String userId, int userType) {
        Map map;
        String eventId = INVALID;
        String buySql = "select * from pub_tenant_res where tenant_id=? and res_code=?";
        List list = jdbcTemplate.queryForList(buySql, new Object[]{tenantId, sysid});
        if (list.size() > 0 && (map = (Map)list.get(0)) != null) {
            String enddate = (String)map.get("end_date");
            try {
                if (this.after(enddate)) {
                    if (1 == userType) {
                        eventId = VALID;
                    } else {
                        String sql = "select count(id) from pub_tenant_user_permission where tenant_id=? and user_id=? and res_code=?";
                        int count = Integer.valueOf((String)jdbcTemplate.queryForObject(sql, String.class, new Object[]{tenantId, userId, sysid}));
                        if (count > 0) {
                            eventId = VALID;
                        }
                    }
                }
            }
            catch (Exception e) {
                this.logger.trace((Object)"Could not retrieve ticket id {} from registry.", (Throwable)e);
            }
        }
        return eventId;
    }

    private String dealMutiAppAuth(List<Map<String, Object>> grouplist, JdbcTemplate jdbcTemplate, String tenantId, String userId, int userType) {
        StringBuffer rescodeBuf = new StringBuffer();
        for (Map<String, Object> oneMap : grouplist) {
            String resCode = (String)oneMap.get("res_code");
            if (StringUtils.isEmpty((Object)resCode)) continue;
            rescodeBuf.append("'" + resCode + "',");
        }
        String eventId = INVALID;
        String buySql = "select * from pub_tenant_res where tenant_id=? and res_code in (" + rescodeBuf.substring(0, rescodeBuf.length() - 1) + ")";
        List list = jdbcTemplate.queryForList(buySql, new Object[]{tenantId});
        if (list.size() > 0) {
            boolean isAfterData = false;
            for (Map map : list) {
                String enddate = (String)map.get("end_date");
                try {
                    if (!this.after(enddate)) continue;
                    isAfterData = true;
                    break;
                }
                catch (Exception e) {
                    this.logger.trace((Object)"Could not retrieve ticket id {} from registry.", (Throwable)e);
                }
            }
            if (isAfterData) {
                if (1 == userType) {
                    eventId = VALID;
                } else {
                    String sql = "select count(id) from pub_tenant_user_permission where tenant_id=? and user_id=? and res_code in (" + rescodeBuf.substring(0, rescodeBuf.length() - 1) + ")";
                    int count = Integer.valueOf((String)jdbcTemplate.queryForObject(sql, String.class, new Object[]{tenantId, userId}));
                    if (count > 0) {
                        eventId = VALID;
                    }
                }
            }
        }
        return eventId;
    }
}

