/*
 * Decompiled with CFR 0.152.
 */
package uap.web.cache;

import com.yonyou.uap.tenant.web.filter.PerformanceLoggerCollector;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springside.modules.nosql.redis.JedisTemplate;
import org.springside.modules.nosql.redis.JedisUtils;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.exceptions.JedisConnectionException;
import redis.clients.jedis.exceptions.JedisDataException;
import redis.clients.jedis.exceptions.JedisException;
import uap.web.cache.CacheManager;
import uap.web.cache.utils.SerializUtil;

public class CacheManager {
    public static final String TOKEN_SEED = "token_seed";
    public static final String DEFAULT_CHARSET = "UTF-8";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private int sessionTimeout = 3600;
    private JedisTemplate jedisTemplate;

    public JedisTemplate getJedisTemplate() {
        return this.jedisTemplate;
    }

    public void setJedisTemplate(JedisTemplate jedisTemplate) {
        this.jedisTemplate = jedisTemplate;
    }

    public int getSessionTimeout() {
        return this.sessionTimeout;
    }

    public void setSessionTimeout(int sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
    }

    public Map<String, Object> getAllSessionAttrCache(String sid) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Map redisMap = this.hgetAll(sid);
        for (byte[] byteKey : redisMap.keySet()) {
            String key = new String(byteKey, Charset.forName(DEFAULT_CHARSET));
            Object obj = SerializUtil.byteToObject((byte[])((byte[])redisMap.get(byteKey)));
            hashMap.put(key, obj);
        }
        this.expire(sid, this.sessionTimeout);
        return hashMap;
    }

    public Map<String, Object> getAllTicketAttrCache(String sid) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Map redisMap = this.hgetAll(sid);
        for (byte[] byteKey : redisMap.keySet()) {
            String key = new String(byteKey, Charset.forName(DEFAULT_CHARSET));
            Object obj = SerializUtil.byteToObjectByKryo((byte[])((byte[])redisMap.get(byteKey)));
            hashMap.put(key, obj);
        }
        this.expire(sid, this.sessionTimeout);
        return hashMap;
    }

    public void removeSessionCache(String sid) {
        this.jedisTemplate.del(new String[]{sid});
    }

    public <T extends Serializable> void putSessionCacheAttribute(String sid, String key, T value) {
        this.putSessionCacheAttribute(sid, key, value, this.sessionTimeout);
    }

    public <T extends Serializable> void putTicketCacheAttribute(String sid, String key, T value) {
        this.putTicketCacheAttribute(sid, key, value, this.sessionTimeout);
    }

    public <T extends Serializable> void putTicketCacheAttribute(String sid, String key, T value, int timeout) {
        this.hsetByKryo(sid, key, value);
        if (timeout > 0) {
            this.expire(sid, timeout);
        }
    }

    public <T extends Serializable> void putSessionCacheAttribute(String sid, String key, T value, int timeout) {
        this.hset(sid, key, value);
        if (timeout > 0) {
            this.expire(sid, timeout);
        }
    }

    public <T extends Serializable> void updateSessionCacheAttribute(String sid, String key, T value) {
        if (this.jedisTemplate.hexists(sid, key).booleanValue()) {
            this.putSessionCacheAttribute(sid, key, value);
        }
    }

    public <T extends Serializable> T getSessionCacheAttribute(String sid, String key) {
        Serializable result = null;
        boolean isExist = this.exists(sid);
        if (isExist) {
            this.expire(sid, this.sessionTimeout);
            result = this.hget(sid, key);
        }
        return (T)result;
    }

    public <T extends Serializable> T getTicketCacheAttribute(String sid, String key) {
        Serializable result = null;
        boolean isExist = this.exists(sid);
        if (isExist) {
            this.expire(sid, this.sessionTimeout);
            result = this.hgetByKryo(sid, key);
        }
        return (T)result;
    }

    public void removeSessionCacheAttribute(String sid, String key) {
        if (StringUtils.isNotBlank((CharSequence)sid) && StringUtils.isNotBlank((CharSequence)key)) {
            this.jedisTemplate.hdel(sid, new String[]{key});
        }
    }

    public boolean removeCacheAttribute(String sid, String key) {
        long count;
        return StringUtils.isNotBlank((CharSequence)sid) && StringUtils.isNotBlank((CharSequence)key) && (count = this.jedisTemplate.hdel(sid, new String[]{key}).longValue()) > 0L;
    }

    public <T extends Serializable> T getUserCache(String key) {
        boolean isExist = this.exists(key);
        Serializable result = null;
        if (isExist) {
            this.expire(key, this.sessionTimeout);
            result = this.get(key);
        }
        return (T)result;
    }

    public <T extends Serializable> T getCurUser(String prefix, String uname) {
        return (T)(StringUtils.isNotBlank((CharSequence)uname) ? this.getUserCache(this.createUserCacheKey(prefix, uname)) : null);
    }

    public <T extends Serializable> void cacheUser(String prefix, String uname, T user) {
        this.putUserCache(this.createUserCacheKey(prefix, uname), user);
    }

    public <T extends Serializable> void cacheUser(String uname, T user) {
        this.putUserCache(this.createUserCacheKey(uname), user);
    }

    public <T extends Serializable> void putUserCache(String key, T value) {
        this.putTimedCache(key, value, this.sessionTimeout);
    }

    private String createUserCacheKey(String prefix, String uname) {
        return "user.info.login" + prefix + ":" + uname;
    }

    private String createUserCacheKey(String uname) {
        return "user.info.login.tenant:" + uname;
    }

    public <T extends Serializable> void disCacheUser(String uname) {
        this.removeCache(this.createUserCacheKey(uname));
    }

    public <T extends Serializable> void disCacheUser(String prefix, String uname) {
        this.removeCache(this.createUserCacheKey(prefix, uname));
    }

    public String getSeedValue(String key) {
        return this.jedisTemplate.get(key);
    }

    public <T extends Serializable> void putTimedCache(String key, T value, int timeout) {
        this.setex(key, value, timeout);
    }

    public <T extends Serializable> void set(String key, T value) {
        this.execute((JedisActionNoResult)new /* Unavailable Anonymous Inner Class!! */);
    }

    public <T extends Serializable> void setex(String key, T value, int timeout) {
        this.execute((JedisActionNoResult)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void expire(String key, int timeout) {
        this.execute((JedisActionNoResult)new /* Unavailable Anonymous Inner Class!! */);
    }

    public Boolean exists(String key) {
        return (Boolean)this.execute((JedisAction)new /* Unavailable Anonymous Inner Class!! */);
    }

    public <T extends Serializable> T get(String key) {
        return (T)((Serializable)this.execute((JedisAction)new /* Unavailable Anonymous Inner Class!! */));
    }

    public <T extends Serializable> T hget(String key, String fieldName) {
        return (T)((Serializable)this.execute((JedisAction)new /* Unavailable Anonymous Inner Class!! */));
    }

    private <T extends Serializable> T hgetByKryo(String key, String fieldName) {
        return (T)((Serializable)this.execute((JedisAction)new /* Unavailable Anonymous Inner Class!! */));
    }

    public Map<byte[], byte[]> hgetAll(String key) {
        return (Map)this.execute((JedisAction)new /* Unavailable Anonymous Inner Class!! */);
    }

    public <T extends Serializable> void hset(String key, String fieldName, T value) {
        this.execute((JedisActionNoResult)new /* Unavailable Anonymous Inner Class!! */);
    }

    private <T extends Serializable> void hsetByKryo(String key, String fieldName, T value) {
        this.execute((JedisActionNoResult)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void removeCache(String key) {
        if (StringUtils.isNotBlank((CharSequence)key)) {
            this.jedisTemplate.del(new String[]{key});
        }
    }

    public boolean remove(String key) {
        if (StringUtils.isNotBlank((CharSequence)key)) {
            return this.jedisTemplate.del(new String[]{key});
        }
        return false;
    }

    public <T> T execute(JedisAction<T> jedisAction) throws JedisException {
        PerformanceLoggerCollector.start((String)"redis");
        Jedis jedis = null;
        boolean broken = false;
        Object result = null;
        try {
            jedis = (Jedis)this.jedisTemplate.getJedisPool().getResource();
            result = jedisAction.action(jedis);
        }
        catch (JedisException e) {
            broken = this.handleJedisException(e);
            throw e;
        }
        finally {
            this.closeResource(jedis, broken);
            PerformanceLoggerCollector.stop((String)"redis");
        }
        return (T)result;
    }

    public void execute(JedisActionNoResult jedisAction) throws JedisException {
        PerformanceLoggerCollector.start((String)"redis");
        Jedis jedis = null;
        boolean broken = false;
        try {
            jedis = (Jedis)this.jedisTemplate.getJedisPool().getResource();
            jedisAction.action(jedis);
        }
        catch (JedisException e) {
            broken = this.handleJedisException(e);
            throw e;
        }
        finally {
            this.closeResource(jedis, broken);
            PerformanceLoggerCollector.stop((String)"redis");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean handleJedisException(JedisException jedisException) {
        if (jedisException instanceof JedisConnectionException) {
            this.logger.error("Redis connection " + this.jedisTemplate.getJedisPool().getAddress() + " lost.", (Throwable)jedisException);
            return true;
        } else if (jedisException instanceof JedisDataException) {
            if (jedisException.getMessage() == null || jedisException.getMessage().indexOf("READONLY") == -1) return false;
            this.logger.error("Redis connection " + this.jedisTemplate.getJedisPool().getAddress() + " are read-only slave.", (Throwable)jedisException);
            return true;
        } else {
            this.logger.error("Jedis exception happen.", (Throwable)jedisException);
        }
        return true;
    }

    protected void closeResource(Jedis jedis, boolean conectionBroken) {
        try {
            if (conectionBroken) {
                this.jedisTemplate.getJedisPool().returnBrokenResource(jedis);
            } else {
                this.jedisTemplate.getJedisPool().returnResource(jedis);
            }
        }
        catch (Exception e) {
            this.logger.error("return back jedis failed, will fore close the jedis.", (Throwable)e);
            JedisUtils.destroyJedis((Jedis)jedis);
        }
    }

    public long getTTL(String key) {
        return (Long)this.execute((JedisAction)new /* Unavailable Anonymous Inner Class!! */);
    }
}

