/*
 * Decompiled with CFR 0.152.
 */
package uap.web.cache.utils;

import com.yonyou.uap.tenant.web.filter.PerformanceLoggerCollector;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URLDecoder;
import java.net.URLEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uap.web.cache.utils.Kryox;
import uap.web.cache.utils.KryoxPool;

public class SerializUtil {
    private static final Logger logger = LoggerFactory.getLogger(SerializUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getStrFromObj(Object obj) {
        String serStr = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        ObjectOutputStream objectOutputStream = null;
        try {
            byteArrayOutputStream = new ByteArrayOutputStream();
            objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(obj);
            serStr = byteArrayOutputStream.toString("ISO-8859-1");
            serStr = URLEncoder.encode(serStr, "UTF-8");
        }
        catch (IOException e) {
            logger.error("file ioException", (Throwable)e);
        }
        finally {
            try {
                if (objectOutputStream != null) {
                    objectOutputStream.close();
                }
            }
            catch (IOException e) {
                logger.error("close  objectOutpuStream exception:", (Throwable)e);
            }
            try {
                if (byteArrayOutputStream != null) {
                    byteArrayOutputStream.close();
                }
            }
            catch (IOException e) {
                logger.error("file ioException", (Throwable)e);
            }
        }
        return serStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getObjectFromStr(String serStr) {
        ByteArrayInputStream byteArrayInputStream = null;
        ObjectInputStream objectInputStream = null;
        Object obj = null;
        try {
            String redStr = URLDecoder.decode(serStr, "UTF-8");
            byteArrayInputStream = new ByteArrayInputStream(redStr.getBytes("ISO-8859-1"));
            objectInputStream = new ObjectInputStream(byteArrayInputStream);
            obj = objectInputStream.readObject();
        }
        catch (Exception e) {
            logger.error("  ioException", (Throwable)e);
        }
        finally {
            try {
                if (objectInputStream != null) {
                    objectInputStream.close();
                }
            }
            catch (IOException e) {
                logger.error("  ioException", (Throwable)e);
            }
            try {
                if (byteArrayInputStream != null) {
                    byteArrayInputStream.close();
                }
            }
            catch (IOException e) {
                logger.error("  byteArrayInputStream close exception:", (Throwable)e);
            }
        }
        return obj;
    }

    public static Object byteToObject(byte[] bytes) {
        PerformanceLoggerCollector.start((String)"serizalize", (String)"byteToObject");
        Object obj = null;
        try {
            ByteArrayInputStream bi = new ByteArrayInputStream(bytes);
            ObjectInputStream oi = new ObjectInputStream(bi);
            obj = oi.readObject();
            bi.close();
            oi.close();
            PerformanceLoggerCollector.stop((String)"serizalize");
        }
        catch (Exception e) {
            logger.error(" Exception ", (Throwable)e);
        }
        return obj;
    }

    public static byte[] objectToByte(Object obj) {
        PerformanceLoggerCollector.start((String)"serizalize", (String)"objectToByte");
        byte[] bytes = null;
        try {
            ByteArrayOutputStream bo = new ByteArrayOutputStream();
            ObjectOutputStream oo = new ObjectOutputStream(bo);
            oo.writeObject(obj);
            bytes = bo.toByteArray();
            bo.close();
            oo.close();
            PerformanceLoggerCollector.stop((String)"serizalize");
        }
        catch (Exception e) {
            logger.error(" get Object exception: ", (Throwable)e);
        }
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object byteToObjectByKryo(byte[] bytes) {
        PerformanceLoggerCollector.start((String)"serizalize", (String)"byteToObjectByKryo");
        Kryox kryox = null;
        Object obj = null;
        try {
            kryox = KryoxPool.getInstance().getKryox();
            kryox.input.setBuffer(bytes, 0, bytes.length);
            obj = kryox.readClassAndObject(kryox.input);
        }
        catch (Exception e) {
            logger.error("byteToObjectByKryo  ", (Throwable)e);
        }
        finally {
            if (kryox != null) {
                KryoxPool.getInstance().returnKryox(kryox);
            }
        }
        PerformanceLoggerCollector.stop((String)"serizalize");
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] objectToByteByKryo(Object obj) {
        PerformanceLoggerCollector.start((String)"serizalize", (String)"objectToByteByKryo");
        Kryox kryox = null;
        try {
            kryox = KryoxPool.getInstance().getKryox();
            kryox.output.clear();
            kryox.writeClassAndObject(kryox.output, obj);
            PerformanceLoggerCollector.stop((String)"serizalize");
            byte[] byArray = kryox.output.toBytes();
            return byArray;
        }
        catch (Exception e) {
            logger.error("objectToByteByKryo:  ", (Throwable)e);
            byte[] byArray = null;
            return byArray;
        }
        finally {
            if (kryox != null) {
                KryoxPool.getInstance().returnKryox(kryox);
            }
        }
    }
}

