/*
 * Decompiled with CFR 0.152.
 */
package uap.web.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.SSLContext;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.FormBodyPart;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import uap.web.utils.AnyTrustStrategy;

/*
 * Exception performing whole class analysis ignored.
 */
public class HttpUtil {
    private static final Log log = LogFactory.getLog(HttpUtil.class);
    public static final String DEFAULT_AGENT = "iuap.httpclient";
    private static int bufferSize = 1024;
    private static volatile HttpUtil instance;
    private ConnectionConfig connConfig = ConnectionConfig.custom().setCharset(Charset.forName(defaultEncoding)).build();
    private SocketConfig socketConfig = SocketConfig.custom().setSoTimeout(10000).build();
    private ConnectionSocketFactory plainSF;
    private KeyStore trustStore;
    private SSLContext sslContext;
    private LayeredConnectionSocketFactory sslSF;
    private Registry<ConnectionSocketFactory> registry;
    private PoolingHttpClientConnectionManager connManager;
    private CloseableHttpClient client;
    public static String defaultEncoding;

    private static List<NameValuePair> paramsConverter(Map<String, String> params) {
        LinkedList<NameValuePair> nvps = new LinkedList<NameValuePair>();
        Set<Map.Entry<String, String>> paramsSet = params.entrySet();
        for (Map.Entry<String, String> paramEntry : paramsSet) {
            nvps.add((NameValuePair)new BasicNameValuePair(paramEntry.getKey(), paramEntry.getValue()));
        }
        return nvps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static String readStream(InputStream in, String encoding) {
        if (in == null) {
            return null;
        }
        try {
            InputStreamReader inReader = null;
            inReader = encoding == null ? new InputStreamReader(in, defaultEncoding) : new InputStreamReader(in, encoding);
            char[] buffer = new char[bufferSize];
            int readLen = 0;
            StringBuffer sb = new StringBuffer();
            while ((readLen = inReader.read(buffer)) != -1) {
                sb.append(buffer, 0, readLen);
            }
            inReader.close();
            String string = sb.toString();
            return string;
        }
        catch (IOException e) {
            log.error((Object)"\u8bfb\u53d6\u8fd4\u56de\u5185\u5bb9\u51fa\u9519", (Throwable)e);
        }
        finally {
            if (null != in) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
        return null;
    }

    private HttpUtil() {
        RegistryBuilder registryBuilder = RegistryBuilder.create();
        this.plainSF = new PlainConnectionSocketFactory();
        registryBuilder.register("http", (Object)this.plainSF);
        try {
            this.trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
            this.sslContext = SSLContexts.custom().useTLS().loadTrustMaterial(this.trustStore, (TrustStrategy)new AnyTrustStrategy()).build();
            this.sslSF = new SSLConnectionSocketFactory(this.sslContext, SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
            registryBuilder.register("https", (Object)this.sslSF);
        }
        catch (KeyStoreException e) {
            throw new RuntimeException(e);
        }
        catch (KeyManagementException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        this.registry = registryBuilder.build();
        this.connManager = new PoolingHttpClientConnectionManager(this.registry);
        this.connManager.setDefaultConnectionConfig(this.connConfig);
        this.connManager.setDefaultSocketConfig(this.socketConfig);
        this.connManager.setDefaultMaxPerRoute(200);
        this.connManager.setMaxTotal(200);
        this.client = HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)this.connManager).setDefaultRequestConfig(RequestConfig.custom().setConnectionRequestTimeout(2000).setConnectTimeout(3000).setSocketTimeout(5000).build()).setUserAgent("iuap.httpclient").build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HttpUtil getInstance() {
        if (instance != null) return instance;
        Class<HttpUtil> clazz = HttpUtil.class;
        synchronized (HttpUtil.class) {
            if (instance != null) return instance;
            instance = new HttpUtil();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public InputStream doGet(String url) throws URISyntaxException, ClientProtocolException, IOException {
        HttpResponse response = this.doGet(url, null);
        return response != null ? response.getEntity().getContent() : null;
    }

    public String doGetForString(String url) throws URISyntaxException, ClientProtocolException, IOException {
        HttpResponse response = this.doGet(url, null);
        String ret = HttpUtil.readStream((InputStream)(response != null ? response.getEntity().getContent() : null), null);
        HttpUtil.releaseQuietly((HttpResponse)response);
        return ret;
    }

    public InputStream doGetForStream(String url, Map<String, String> queryParams) throws URISyntaxException, ClientProtocolException, IOException {
        HttpResponse response = this.doGet(url, queryParams);
        return response != null ? response.getEntity().getContent() : null;
    }

    public String doGetForString(String url, Map<String, String> queryParams) throws URISyntaxException, ClientProtocolException, IOException {
        HttpResponse response = this.doGet(url, queryParams);
        String ret = HttpUtil.readStream((InputStream)(response != null ? response.getEntity().getContent() : null), null);
        HttpUtil.releaseQuietly((HttpResponse)response);
        return ret;
    }

    public InputStream doGetForStream(String url, Map<String, String> queryParams, Map<String, String> headers) throws URISyntaxException, ClientProtocolException, IOException {
        HttpResponse response = this.doGet(url, queryParams, headers);
        return response != null ? response.getEntity().getContent() : null;
    }

    public InputStream doDeleteForStream(String url, Map<String, String> queryParams, Map<String, String> headers) throws URISyntaxException, ClientProtocolException, IOException {
        HttpResponse response = this.doDelete(url, queryParams, headers);
        return response != null ? response.getEntity().getContent() : null;
    }

    public String doGetForString(String url, Map<String, String> queryParams, Map<String, String> headers) throws URISyntaxException, ClientProtocolException, IOException {
        HttpResponse response = this.doGet(url, queryParams, headers);
        String ret = HttpUtil.readStream((InputStream)(response != null ? response.getEntity().getContent() : null), null);
        HttpUtil.releaseQuietly((HttpResponse)response);
        return ret;
    }

    public String doDeleteForString(String url, Map<String, String> queryParams, Map<String, String> headers) throws URISyntaxException, ClientProtocolException, IOException {
        HttpResponse response = this.doDelete(url, queryParams, headers);
        String ret = HttpUtil.readStream((InputStream)(response != null ? response.getEntity().getContent() : null), null);
        HttpUtil.releaseQuietly((HttpResponse)response);
        return ret;
    }

    public HttpResponse doGet(String url, Map<String, String> queryParams) throws URISyntaxException, ClientProtocolException, IOException {
        return this.doGet(url, queryParams, null);
    }

    public HttpResponse doGet(String url, Map<String, String> queryParams, Map<String, String> headers) throws URISyntaxException, ClientProtocolException, IOException {
        HttpGet gm = new HttpGet();
        URIBuilder builder = new URIBuilder(url);
        if (queryParams != null && !queryParams.isEmpty()) {
            builder.setParameters(HttpUtil.paramsConverter(queryParams));
        }
        gm.setURI(builder.build());
        if (headers != null) {
            for (String name : headers.keySet()) {
                gm.addHeader(name, headers.get(name));
            }
        }
        return this.client.execute((HttpUriRequest)gm);
    }

    public HttpResponse doDelete(String url, Map<String, String> queryParams, Map<String, String> headers) throws URISyntaxException, ClientProtocolException, IOException {
        HttpDelete hd = new HttpDelete();
        URIBuilder builder = new URIBuilder(url);
        if (queryParams != null && !queryParams.isEmpty()) {
            builder.setParameters(HttpUtil.paramsConverter(queryParams));
        }
        hd.setURI(builder.build());
        if (headers != null) {
            for (String name : headers.keySet()) {
                hd.addHeader(name, headers.get(name));
            }
        }
        return this.client.execute((HttpUriRequest)hd);
    }

    public HttpResponse doPut(String url, Map<String, String> queryParams, Map<String, String> headers) throws URISyntaxException, ClientProtocolException, IOException {
        HttpPut hp = new HttpPut();
        URIBuilder builder = new URIBuilder(url);
        if (queryParams != null && !queryParams.isEmpty()) {
            builder.setParameters(HttpUtil.paramsConverter(queryParams));
        }
        hp.setURI(builder.build());
        if (headers != null) {
            for (String name : headers.keySet()) {
                hp.addHeader(name, headers.get(name));
            }
        }
        return this.client.execute((HttpUriRequest)hp);
    }

    public InputStream doPostForStream(String url, Map<String, String> queryParams) throws URISyntaxException, ClientProtocolException, IOException {
        HttpResponse response = this.doPost(url, queryParams, null);
        return response != null ? response.getEntity().getContent() : null;
    }

    public String doPostForString(String url, Map<String, String> queryParams) throws URISyntaxException, ClientProtocolException, IOException {
        HttpResponse response = this.doPost(url, queryParams, null);
        String ret = HttpUtil.readStream((InputStream)(response != null ? response.getEntity().getContent() : null), null);
        HttpUtil.releaseQuietly((HttpResponse)response);
        return ret;
    }

    public InputStream doPostForStream(String url, Map<String, String> queryParams, Map<String, String> formParams) throws URISyntaxException, ClientProtocolException, IOException {
        HttpResponse response = this.doPost(url, queryParams, formParams);
        return response != null ? response.getEntity().getContent() : null;
    }

    public String doPostRetString(String url, Map<String, String> queryParams, Map<String, String> formParams) throws URISyntaxException, ClientProtocolException, IOException {
        HttpResponse response = this.doPost(url, queryParams, formParams);
        String ret = HttpUtil.readStream((InputStream)(response != null ? response.getEntity().getContent() : null), null);
        HttpUtil.releaseQuietly((HttpResponse)response);
        return ret;
    }

    public InputStream doPostForStream(String url, Map<String, String> queryParams, Map<String, String> formParams, Map<String, String> headers) throws URISyntaxException, ClientProtocolException, IOException {
        HttpResponse response = this.doPost(url, queryParams, formParams, headers);
        return response != null ? response.getEntity().getContent() : null;
    }

    public String doPostRetString(String url, Map<String, String> queryParams, Map<String, String> formParams, Map<String, String> headers) throws URISyntaxException, ClientProtocolException, IOException {
        HttpResponse response = this.doPost(url, queryParams, formParams, headers);
        String ret = HttpUtil.readStream((InputStream)(response != null ? response.getEntity().getContent() : null), null);
        HttpUtil.releaseQuietly((HttpResponse)response);
        return ret;
    }

    public HttpResponse doPost(String url, Map<String, String> queryParams, Map<String, String> formParams) throws URISyntaxException, ClientProtocolException, IOException {
        return this.doPost(url, queryParams, formParams, null);
    }

    public HttpResponse doPost(String url, Map<String, String> queryParams, Map<String, String> formParams, Map<String, String> headers) throws URISyntaxException, ClientProtocolException, IOException {
        HttpPost pm = new HttpPost();
        URIBuilder builder = new URIBuilder(url);
        if (queryParams != null && !queryParams.isEmpty()) {
            builder.setParameters(HttpUtil.paramsConverter(queryParams));
        }
        pm.setURI(builder.build());
        if (formParams != null && !formParams.isEmpty()) {
            pm.setEntity((HttpEntity)new UrlEncodedFormEntity(HttpUtil.paramsConverter(formParams), defaultEncoding));
        }
        if (headers != null) {
            for (String name : headers.keySet()) {
                pm.addHeader(name, headers.get(name));
            }
        }
        return this.client.execute((HttpUriRequest)pm);
    }

    public HttpResponse doPostForString(String url, Map<String, String> queryParams, String requestBody, Map<String, String> headers) throws URISyntaxException, ClientProtocolException, IOException {
        HttpPost pm = new HttpPost();
        URIBuilder builder = new URIBuilder(url);
        if (queryParams != null && !queryParams.isEmpty()) {
            builder.setParameters(HttpUtil.paramsConverter(queryParams));
        }
        pm.setURI(builder.build());
        if (requestBody != null && !requestBody.isEmpty()) {
            pm.setEntity((HttpEntity)new StringEntity(requestBody, defaultEncoding));
        }
        if (headers != null) {
            for (String name : headers.keySet()) {
                pm.addHeader(name, headers.get(name));
            }
        }
        return this.client.execute((HttpUriRequest)pm);
    }

    public HttpResponse doPut(String url, Map<String, String> queryParams, Map<String, String> formParams, Map<String, String> headers) throws URISyntaxException, ClientProtocolException, IOException {
        HttpPut pm = new HttpPut();
        URIBuilder builder = new URIBuilder(url);
        if (queryParams != null && !queryParams.isEmpty()) {
            builder.setParameters(HttpUtil.paramsConverter(queryParams));
        }
        pm.setURI(builder.build());
        if (formParams != null && !formParams.isEmpty()) {
            pm.setEntity((HttpEntity)new UrlEncodedFormEntity(HttpUtil.paramsConverter(formParams), defaultEncoding));
        }
        if (headers != null) {
            for (String name : headers.keySet()) {
                pm.addHeader(name, headers.get(name));
            }
        }
        return this.client.execute((HttpUriRequest)pm);
    }

    public HttpResponse multipartPost(String url, Map<String, String> queryParams, List<FormBodyPart> formParts) throws URISyntaxException, ClientProtocolException, IOException {
        return this.multipartPost(url, queryParams, formParts, null);
    }

    public HttpResponse multipartPost(String url, Map<String, String> queryParams, List<FormBodyPart> formParts, Map<String, String> headers) throws URISyntaxException, ClientProtocolException, IOException {
        HttpPost pm = new HttpPost();
        URIBuilder builder = new URIBuilder(url);
        if (queryParams != null && !queryParams.isEmpty()) {
            builder.setParameters(HttpUtil.paramsConverter(queryParams));
        }
        pm.setURI(builder.build());
        if (formParts != null && !formParts.isEmpty()) {
            MultipartEntityBuilder entityBuilder = MultipartEntityBuilder.create();
            entityBuilder = entityBuilder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
            for (FormBodyPart formPart : formParts) {
                entityBuilder = entityBuilder.addPart(formPart.getName(), formPart.getBody());
            }
            pm.setEntity(entityBuilder.build());
        }
        if (headers != null) {
            for (String name : headers.keySet()) {
                pm.addHeader(name, headers.get(name));
            }
        }
        return this.client.execute((HttpUriRequest)pm);
    }

    public HttpResponse postFormForBody(String url, String bodyParams, List<Header> headers) {
        HttpPost httpPost = null;
        CloseableHttpResponse httpResponse = null;
        try {
            httpPost = new HttpPost(url);
            if (CollectionUtils.isNotEmpty(headers)) {
                for (Header header : headers) {
                    httpPost.addHeader(header);
                }
            }
            if (null != bodyParams) {
                httpPost.setEntity((HttpEntity)new StringEntity(bodyParams, Charset.forName("UTF-8")));
            }
            httpResponse = this.client.execute((HttpUriRequest)httpPost);
            return httpResponse;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public HttpResponse putFormForBody(String url, String bodyParams, List<Header> headers) {
        HttpPut httpPut = null;
        CloseableHttpResponse httpResponse = null;
        try {
            httpPut = new HttpPut(url);
            if (CollectionUtils.isNotEmpty(headers)) {
                for (Header header : headers) {
                    httpPut.addHeader(header);
                }
            }
            if (null != bodyParams) {
                httpPut.setEntity((HttpEntity)new StringEntity(bodyParams, Charset.forName("UTF-8")));
            }
            httpResponse = this.client.execute((HttpUriRequest)httpPut);
            return httpResponse;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void releaseQuietly(HttpResponse response) {
        if (null != response) {
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            if (response instanceof CloseableHttpResponse) {
                try {
                    ((CloseableHttpResponse)response).close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    static {
        defaultEncoding = "utf-8";
    }
}

