/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.apache.http.client.protocol;

import com.yonyou.apache.http.HttpEntity;
import com.yonyou.apache.http.HttpEntityEnclosingRequest;
import com.yonyou.apache.http.HttpException;
import com.yonyou.apache.http.HttpRequest;
import com.yonyou.apache.http.HttpRequestInterceptor;
import com.yonyou.apache.http.HttpVersion;
import com.yonyou.apache.http.ProtocolVersion;
import com.yonyou.apache.http.annotation.Immutable;
import com.yonyou.apache.http.client.config.RequestConfig;
import com.yonyou.apache.http.client.protocol.HttpClientContext;
import com.yonyou.apache.http.protocol.HttpContext;
import com.yonyou.apache.http.util.Args;
import java.io.IOException;

@Immutable
public class RequestExpectContinue
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (!request.containsHeader("Expect") && request instanceof HttpEntityEnclosingRequest) {
            HttpClientContext clientContext;
            RequestConfig config;
            ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
            HttpEntity entity = ((HttpEntityEnclosingRequest)request).getEntity();
            if (entity != null && entity.getContentLength() != 0L && !ver.lessEquals(HttpVersion.HTTP_1_0) && (config = (clientContext = HttpClientContext.adapt(context)).getRequestConfig()).isExpectContinueEnabled()) {
                request.addHeader("Expect", "100-continue");
            }
        }
    }
}

