/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.apache.http.impl;

import com.yonyou.apache.http.HttpResponse;
import com.yonyou.apache.http.HttpResponseFactory;
import com.yonyou.apache.http.ProtocolVersion;
import com.yonyou.apache.http.ReasonPhraseCatalog;
import com.yonyou.apache.http.StatusLine;
import com.yonyou.apache.http.annotation.Immutable;
import com.yonyou.apache.http.impl.EnglishReasonPhraseCatalog;
import com.yonyou.apache.http.message.BasicHttpResponse;
import com.yonyou.apache.http.message.BasicStatusLine;
import com.yonyou.apache.http.protocol.HttpContext;
import com.yonyou.apache.http.util.Args;
import java.util.Locale;

@Immutable
public class DefaultHttpResponseFactory
implements HttpResponseFactory {
    public static final DefaultHttpResponseFactory INSTANCE = new DefaultHttpResponseFactory();
    protected final ReasonPhraseCatalog reasonCatalog;

    public DefaultHttpResponseFactory(ReasonPhraseCatalog catalog) {
        this.reasonCatalog = Args.notNull(catalog, "Reason phrase catalog");
    }

    public DefaultHttpResponseFactory() {
        this(EnglishReasonPhraseCatalog.INSTANCE);
    }

    @Override
    public HttpResponse newHttpResponse(ProtocolVersion ver, int status, HttpContext context) {
        Args.notNull(ver, "HTTP version");
        Locale loc = this.determineLocale(context);
        String reason = this.reasonCatalog.getReason(status, loc);
        BasicStatusLine statusline = new BasicStatusLine(ver, status, reason);
        return new BasicHttpResponse(statusline, this.reasonCatalog, loc);
    }

    @Override
    public HttpResponse newHttpResponse(StatusLine statusline, HttpContext context) {
        Args.notNull(statusline, "Status line");
        return new BasicHttpResponse(statusline, this.reasonCatalog, this.determineLocale(context));
    }

    protected Locale determineLocale(HttpContext context) {
        return Locale.getDefault();
    }
}

