/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.apache.http.impl.io;

import com.yonyou.apache.http.HttpResponse;
import com.yonyou.apache.http.HttpResponseFactory;
import com.yonyou.apache.http.annotation.Immutable;
import com.yonyou.apache.http.config.MessageConstraints;
import com.yonyou.apache.http.impl.DefaultHttpResponseFactory;
import com.yonyou.apache.http.impl.io.DefaultHttpResponseParser;
import com.yonyou.apache.http.io.HttpMessageParser;
import com.yonyou.apache.http.io.HttpMessageParserFactory;
import com.yonyou.apache.http.io.SessionInputBuffer;
import com.yonyou.apache.http.message.BasicLineParser;
import com.yonyou.apache.http.message.LineParser;

@Immutable
public class DefaultHttpResponseParserFactory
implements HttpMessageParserFactory<HttpResponse> {
    public static final DefaultHttpResponseParserFactory INSTANCE = new DefaultHttpResponseParserFactory();
    private final LineParser lineParser;
    private final HttpResponseFactory responseFactory;

    public DefaultHttpResponseParserFactory(LineParser lineParser, HttpResponseFactory responseFactory) {
        this.lineParser = lineParser != null ? lineParser : BasicLineParser.INSTANCE;
        this.responseFactory = responseFactory != null ? responseFactory : DefaultHttpResponseFactory.INSTANCE;
    }

    public DefaultHttpResponseParserFactory() {
        this(null, null);
    }

    @Override
    public HttpMessageParser<HttpResponse> create(SessionInputBuffer buffer, MessageConstraints constraints) {
        return new DefaultHttpResponseParser(buffer, this.lineParser, this.responseFactory, constraints);
    }
}

