/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.cloud.auth.sdk.client;

import com.yonyou.apache.http.Header;
import com.yonyou.apache.http.HttpResponse;
import com.yonyou.apache.http.NameValuePair;
import com.yonyou.apache.http.client.ClientProtocolException;
import com.yonyou.apache.http.client.ResponseHandler;
import com.yonyou.apache.http.client.entity.UrlEncodedFormEntity;
import com.yonyou.apache.http.client.methods.CloseableHttpResponse;
import com.yonyou.apache.http.client.methods.HttpPost;
import com.yonyou.apache.http.client.methods.HttpRequestBase;
import com.yonyou.apache.http.client.methods.HttpUriRequest;
import com.yonyou.apache.http.client.utils.URIBuilder;
import com.yonyou.apache.http.message.BasicHeader;
import com.yonyou.apache.http.util.Asserts;
import com.yonyou.cloud.auth.sdk.client.utils.codec.SignUtils;
import com.yonyou.cloud.auth.sdk.client.utils.http.EnumRequestType;
import com.yonyou.cloud.auth.sdk.client.utils.http.HttpClient4Utils;
import com.yonyou.cloud.auth.sdk.client.utils.http.HttpResult;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthSDKClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthSDKClient.class);
    private String accessKey;
    private String accessSecret;

    public AuthSDKClient(String accessKey, String accessSecret) {
        Asserts.notBlank(accessKey, "accessKey");
        Asserts.notBlank(accessSecret, "accessSecret");
        this.accessKey = accessKey;
        this.accessSecret = accessSecret;
    }

    public HttpResult execute(HttpRequestBase request) {
        HttpResult httpResult;
        Asserts.notBlank(this.accessKey, "accessKey");
        Asserts.notBlank(this.accessSecret, "accessSecret");
        HttpResponse httpResponse = null;
        try {
            HttpClient4Utils.signHttpReq(this.accessKey, this.accessSecret, request);
            httpResponse = HttpClient4Utils.httpClient.execute(request);
            HttpResult httpResult2 = new HttpResult();
            httpResult2.setStatusCode(httpResponse.getStatusLine().getStatusCode());
            httpResult2.setResponseString(HttpClient4Utils.httpEntityToString(httpResponse.getEntity()));
            httpResult = httpResult2;
            HttpClient4Utils.closeHttpComponent(request, (CloseableHttpResponse)httpResponse, null == httpResponse ? null : httpResponse.getEntity());
        }
        catch (Exception e) {
            try {
                LOGGER.error("", (Throwable)e);
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                HttpClient4Utils.closeHttpComponent(request, (CloseableHttpResponse)httpResponse, null == httpResponse ? null : httpResponse.getEntity());
                throw throwable;
            }
        }
        return httpResult;
    }

    public <T> T execute(String reqUrl, Map<String, List<String>> paramMap, Map<String, List<String>> headerMap, EnumRequestType requestType, ResponseHandler<T> responseHandler) {
        Asserts.notBlank(this.accessKey, "accessKey");
        Asserts.notBlank(this.accessSecret, "accessSecret");
        Asserts.notNull((Object)requestType, "requestType");
        HttpRequestBase httpRequest = requestType.getInstanceByType();
        try {
            T ret;
            URIBuilder uriBuilder = new URIBuilder(reqUrl).setCharset(StandardCharsets.UTF_8);
            List<NameValuePair> nvParams = HttpClient4Utils.buildNameValuePairFromMap(paramMap);
            if (CollectionUtils.isNotEmpty(nvParams)) {
                if (httpRequest instanceof HttpPost) {
                    ((HttpPost)httpRequest).setEntity(new UrlEncodedFormEntity(nvParams, StandardCharsets.UTF_8));
                } else {
                    uriBuilder.addParameters(nvParams);
                }
            }
            httpRequest.setURI(uriBuilder.build());
            List<Header> headers = HttpClient4Utils.buildHeadersFromMap(headerMap);
            if (CollectionUtils.isNotEmpty(headers)) {
                httpRequest.setHeaders(headers.toArray(new Header[headers.size()]));
            }
            String url = HttpClient4Utils.getDomainByURI(httpRequest.getURI());
            paramMap = HttpClient4Utils.getReqParamByUriQuerys(httpRequest.getURI(), null, paramMap);
            httpRequest.addHeader("YYCtoken", SignUtils.getToken((String)this.accessKey, (String)this.accessSecret, (String)url, paramMap));
            if (ArrayUtils.isEmpty((Object[])httpRequest.getHeaders("Content-Type"))) {
                httpRequest.addHeader(new BasicHeader("Content-Type", HttpClient4Utils.HTTP_CONTENT_TYPE));
            }
            T t = ret = HttpClient4Utils.httpClient.execute((HttpUriRequest)httpRequest, responseHandler);
            return t;
        }
        catch (Exception e) {
            LOGGER.error("", (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            HttpClient4Utils.closeHttpComponent(httpRequest, null, null);
        }
    }

    public HttpResult execute(String reqUrl, Map<String, List<String>> paramMap, Map<String, List<String>> headerMap, EnumRequestType requestType) {
        HttpResult ret = this.execute(reqUrl, paramMap, headerMap, requestType, new ResponseHandler<HttpResult>(){

            @Override
            public HttpResult handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                HttpResult httpResult = new HttpResult();
                httpResult.setStatusCode(response.getStatusLine().getStatusCode());
                httpResult.setResponseString(HttpClient4Utils.httpEntityToString(response.getEntity()));
                return httpResult;
            }
        });
        return ret;
    }
}

