/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.cloud.auth.sdk.client.utils.http;

import com.yonyou.apache.http.Header;
import com.yonyou.apache.http.HttpEntity;
import com.yonyou.apache.http.HttpResponse;
import com.yonyou.apache.http.NameValuePair;
import com.yonyou.apache.http.client.ResponseHandler;
import com.yonyou.apache.http.client.config.RequestConfig;
import com.yonyou.apache.http.client.entity.UrlEncodedFormEntity;
import com.yonyou.apache.http.client.methods.CloseableHttpResponse;
import com.yonyou.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import com.yonyou.apache.http.client.methods.HttpGet;
import com.yonyou.apache.http.client.methods.HttpPost;
import com.yonyou.apache.http.client.methods.HttpRequestBase;
import com.yonyou.apache.http.client.methods.HttpUriRequest;
import com.yonyou.apache.http.client.protocol.HttpClientContext;
import com.yonyou.apache.http.client.utils.URIBuilder;
import com.yonyou.apache.http.config.ConnectionConfig;
import com.yonyou.apache.http.config.SocketConfig;
import com.yonyou.apache.http.conn.ConnectionKeepAliveStrategy;
import com.yonyou.apache.http.impl.client.BasicCookieStore;
import com.yonyou.apache.http.impl.client.CloseableHttpClient;
import com.yonyou.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import com.yonyou.apache.http.impl.client.HttpClientBuilder;
import com.yonyou.apache.http.impl.client.HttpClients;
import com.yonyou.apache.http.message.BasicHeader;
import com.yonyou.apache.http.message.BasicNameValuePair;
import com.yonyou.apache.http.protocol.HttpContext;
import com.yonyou.apache.http.util.EntityUtils;
import com.yonyou.cloud.auth.sdk.client.AccessConstants;
import com.yonyou.cloud.auth.sdk.client.utils.codec.SignUtils;
import com.yonyou.cloud.auth.sdk.client.utils.http.EnumConntionType;
import com.yonyou.cloud.auth.sdk.client.utils.http.HttpResult;
import com.yonyou.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class HttpClient4Utils {
    private static final int CONNECTION_REQUEST_TIMEOUT = Integer.parseInt(System.getProperty("http.connectreq.timeout", "2000"));
    private static final int CONNECTION_TIMEOUT_DEFAULT = Integer.parseInt(System.getProperty("http.connect.timeout", "3000"));
    private static final int SOCKET_TIMEOUT_DEFAULT = Integer.parseInt(System.getProperty("http.socket.timeout", "4000"));
    public static final int SO_LINGER = 0;
    public static final int INFINITE_TIMEOUT = 0;
    public static final int SOCKET_BUFFER_SIZE_DEFAULT = 8192;
    public static final int RETRY_COUNT_DEFAULT = 2;
    public static final String DEFAULT_CHARSET = StandardCharsets.UTF_8.name();
    public static final String HTTP_CONTENT_TYPE = "application/x-www-form-urlencoded; charset=" + DEFAULT_CHARSET;
    public static final String DEFAULT_AGENT = "auth-sdk-client.iuap.httpclient";
    public static final String CONTENT_TYPE_NAME = "Content-Type";
    public static final String URL_SEPARATOR = "/";
    public static final String HEADER_COOKIE = "Cookie";
    public static final CloseableHttpClient httpClient = HttpClient4Utils.buildHttpClient(SOCKET_TIMEOUT_DEFAULT);
    public static final CloseableHttpClient httpClientNoTimeout = HttpClient4Utils.buildHttpClient(0);
    public static final String COOKIE_STORE_FIELD = "cookieStore";
    private static final int MAX_CONN_TOTAL = 300;

    private static CloseableHttpClient buildHttpClient(int socketTimeout) {
        HttpClientBuilder httpClientBuilder = HttpClients.custom().setMaxConnTotal(300).setMaxConnPerRoute(300);
        httpClientBuilder.setDefaultRequestConfig(RequestConfig.custom().setConnectionRequestTimeout(CONNECTION_REQUEST_TIMEOUT).setConnectTimeout(CONNECTION_TIMEOUT_DEFAULT).setSocketTimeout(socketTimeout).build());
        httpClientBuilder.setDefaultSocketConfig(SocketConfig.custom().setSoLinger(0).setSoKeepAlive(false).setTcpNoDelay(true).setSoTimeout(socketTimeout).build());
        httpClientBuilder.setDefaultConnectionConfig(ConnectionConfig.custom().setBufferSize(8192).setCharset(Charset.forName(DEFAULT_CHARSET)).build());
        httpClientBuilder.setRetryHandler(new DefaultHttpRequestRetryHandler(2, false));
        httpClientBuilder.setUserAgent(DEFAULT_AGENT);
        ConnectionKeepAliveStrategy connectionKeepAliveStrategy = new ConnectionKeepAliveStrategy(){

            @Override
            public long getKeepAliveDuration(HttpResponse httpResponse, HttpContext httpContext) {
                return 5000L;
            }
        };
        httpClientBuilder.setKeepAliveStrategy(connectionKeepAliveStrategy);
        return httpClientBuilder.build();
    }

    public static CloseableHttpClient getHttpClient() {
        return httpClient;
    }

    public static CloseableHttpClient getHttpClientNoTimeout() {
        return httpClientNoTimeout;
    }

    public static HttpResult getForm(String url, Map<String, ?> paramMap) {
        HttpResult httpResult;
        HttpGet httpGet = null;
        HttpResponse httpResponse = null;
        try {
            List<NameValuePair> paramList = null;
            if (paramMap != null && !paramMap.isEmpty()) {
                paramList = HttpClient4Utils.buildNameValuePairFromMap(paramMap);
            }
            url = HttpClient4Utils.buildURL(url, null, paramList);
            httpGet = new HttpGet(url);
            httpResponse = httpClient.execute(HttpClient4Utils.signHttpReq(httpGet));
            HttpResult httpResult2 = new HttpResult();
            httpResult2.setStatusCode(httpResponse.getStatusLine().getStatusCode());
            httpResult2.setResponseString(HttpClient4Utils.httpEntityToString(httpResponse.getEntity()));
            httpResult = httpResult2;
            HttpClient4Utils.closeHttpComponent(httpGet, (CloseableHttpResponse)httpResponse, null == httpResponse ? null : httpResponse.getEntity());
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                HttpClient4Utils.closeHttpComponent(httpGet, (CloseableHttpResponse)httpResponse, null == httpResponse ? null : httpResponse.getEntity());
                throw throwable;
            }
        }
        return httpResult;
    }

    public static HttpResult postForm(String url, List<NameValuePair> paramsPair, EnumConntionType conntionType) {
        return HttpClient4Utils.postForm(url, paramsPair, null, conntionType);
    }

    public static HttpResult postForm(String url, List<NameValuePair> paramsPair, List<Header> headers, EnumConntionType conntionType) {
        return HttpClient4Utils.postForm(url, paramsPair, headers, conntionType, false);
    }

    public static HttpResult postForm(String url, List<NameValuePair> paramsPair, List<Header> headers, EnumConntionType conntionType, boolean clearCookieStore) {
        try {
            UrlEncodedFormEntity httpEntity = null;
            if (CollectionUtils.isNotEmpty(paramsPair)) {
                httpEntity = new UrlEncodedFormEntity(paramsPair, DEFAULT_CHARSET);
            }
            if (null == headers) {
                headers = Lists.newArrayList();
            }
            headers.add(new BasicHeader(CONTENT_TYPE_NAME, HTTP_CONTENT_TYPE));
            return HttpClient4Utils.postForm(url, httpEntity, headers, conntionType, clearCookieStore);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static HttpResult postForm(String url, HttpEntity httpEntity, List<Header> headers, EnumConntionType conntionType) {
        return HttpClient4Utils.postForm(url, httpEntity, headers, conntionType, false);
    }

    public static HttpResult postForm(String url, HttpEntity httpEntity, List<Header> headers, EnumConntionType conntionType, boolean clearCookieStore) {
        HttpResult httpResult;
        HttpPost httpPost = null;
        HttpResponse httpResponse = null;
        try {
            httpPost = new HttpPost(url);
            if (null != httpEntity) {
                httpPost.setEntity(httpEntity);
            }
            if (CollectionUtils.isNotEmpty(headers)) {
                for (Header header : headers) {
                    httpPost.addHeader(header);
                }
            }
            HttpClientContext httpContext = null;
            if (clearCookieStore) {
                httpContext = HttpClientContext.create();
                httpContext.setCookieStore(new BasicCookieStore());
            }
            httpResponse = HttpClient4Utils.chooseHttpClient(conntionType).execute((HttpUriRequest)HttpClient4Utils.signHttpReq(httpPost), httpContext);
            HttpResult httpResult2 = new HttpResult();
            httpResult2.setStatusCode(httpResponse.getStatusLine().getStatusCode());
            httpResult2.setResponseString(HttpClient4Utils.httpEntityToString(httpResponse.getEntity()));
            httpResult = httpResult2;
            HttpClient4Utils.closeHttpComponent(httpPost, (CloseableHttpResponse)httpResponse, null == httpResponse ? null : httpResponse.getEntity());
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                HttpClient4Utils.closeHttpComponent(httpPost, (CloseableHttpResponse)httpResponse, null == httpResponse ? null : httpResponse.getEntity());
                throw throwable;
            }
        }
        return httpResult;
    }

    public static <T> T postFormCallback(String url, List<NameValuePair> paramsPair, ResponseHandler<T> responseHandler, EnumConntionType conntionType) {
        return HttpClient4Utils.postFormCallback(url, paramsPair, null, responseHandler, conntionType);
    }

    public static <T> T postFormCallback(String url, List<NameValuePair> formParams, List<Header> headers, ResponseHandler<T> responseHandler, EnumConntionType conntionType) {
        HttpPost httpPost = null;
        try {
            T respHandlerRet;
            httpPost = new HttpPost(url);
            if (CollectionUtils.isNotEmpty(formParams)) {
                httpPost.setEntity(new UrlEncodedFormEntity(formParams, DEFAULT_CHARSET));
            }
            httpPost.setHeader(CONTENT_TYPE_NAME, HTTP_CONTENT_TYPE);
            if (CollectionUtils.isNotEmpty(headers)) {
                for (Header header : headers) {
                    httpPost.addHeader(header);
                }
            }
            T t = respHandlerRet = HttpClient4Utils.chooseHttpClient(conntionType).execute((HttpUriRequest)HttpClient4Utils.signHttpReq(httpPost), responseHandler);
            return t;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            HttpClient4Utils.closeHttpComponent(httpPost, null, null);
        }
    }

    public static String httpEntityToString(HttpEntity httpEntity) {
        try {
            return EntityUtils.toString(httpEntity, DEFAULT_CHARSET);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static CloseableHttpClient chooseHttpClient(EnumConntionType conntionType) {
        if (null == conntionType || conntionType == EnumConntionType.SHORT) {
            return httpClient;
        }
        return httpClientNoTimeout;
    }

    public static boolean closeHttpComponent(HttpRequestBase httpRequestBase, CloseableHttpResponse httpResponse, HttpEntity httpEntity) {
        boolean ret = true;
        try {
            if (null != httpRequestBase) {
                httpRequestBase.abort();
            }
        }
        catch (Exception e) {
            ret = false;
        }
        try {
            if (null != httpEntity) {
                EntityUtils.consume(httpEntity);
            }
        }
        catch (IOException e) {
            ret = false;
        }
        try {
            if (null != httpResponse) {
                httpResponse.close();
            }
        }
        catch (IOException e) {
            ret = false;
        }
        return ret;
    }

    public static boolean shutdown() {
        try {
            if (null != httpClient) {
                httpClient.close();
            }
            if (null != httpClientNoTimeout) {
                httpClientNoTimeout.close();
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static String buildURL(String url, List<String> uris, List<NameValuePair> queryParams) {
        try {
            if (StringUtils.isNotBlank((CharSequence)url)) {
                StringBuilder ret = new StringBuilder(url).append(URL_SEPARATOR);
                if (CollectionUtils.isNotEmpty(uris)) {
                    for (String uri : uris) {
                        if (!StringUtils.isNotBlank((CharSequence)uri)) continue;
                        ret.append(StringUtils.trimToEmpty((String)uri)).append(URL_SEPARATOR);
                    }
                }
                if (CollectionUtils.isNotEmpty(queryParams)) {
                    URIBuilder uriBuilder = new URIBuilder(ret.toString()).setCharset(StandardCharsets.UTF_8);
                    return uriBuilder.setParameters(queryParams).build().toString();
                }
                return ret.toString();
            }
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static HttpRequestBase signHttpReq(String accessKey, String accessSecret, HttpRequestBase req) throws Exception {
        HttpEntity httpEntity;
        String query = null;
        if (req instanceof HttpEntityEnclosingRequestBase && null != (httpEntity = ((HttpEntityEnclosingRequestBase)req).getEntity()) && httpEntity instanceof UrlEncodedFormEntity) {
            String paramsStr = IOUtils.toString((InputStream)httpEntity.getContent(), (Charset)StandardCharsets.UTF_8);
            query = new URIBuilder(paramsStr).getPath();
        }
        String token = SignUtils.getToken((String)accessKey, (String)accessSecret, (URI)req.getURI(), Lists.newArrayList(query));
        req.addHeader("YYCtoken", token);
        if (ArrayUtils.isEmpty((Object[])req.getHeaders(CONTENT_TYPE_NAME))) {
            req.addHeader(new BasicHeader(CONTENT_TYPE_NAME, HTTP_CONTENT_TYPE));
        }
        return req;
    }

    public static HttpRequestBase signHttpReq(HttpRequestBase req) throws Exception {
        return HttpClient4Utils.signHttpReq(AccessConstants.ACCESS_KEY, AccessConstants.ACCESS_SECRET, req);
    }

    public static List<NameValuePair> buildNameValuePairFromMap(Map<String, ?> paramMap) {
        if (MapUtils.isEmpty(paramMap)) {
            return null;
        }
        ArrayList<NameValuePair> ret = Lists.newArrayList();
        for (Map.Entry<String, ?> e : paramMap.entrySet()) {
            String key = e.getKey();
            Object value = e.getValue();
            if (value == null) continue;
            if (value instanceof Collection) {
                Collection coll = (Collection)value;
                if (!CollectionUtils.isNotEmpty((Collection)coll)) continue;
                for (Object var : coll) {
                    ret.add(new BasicNameValuePair(key, String.valueOf(var)));
                }
                continue;
            }
            if (value instanceof Object[]) {
                Object[] objs = (Object[])value;
                if (!ArrayUtils.isNotEmpty((Object[])objs)) continue;
                for (Object var : objs) {
                    ret.add(new BasicNameValuePair(key, String.valueOf(var)));
                }
                continue;
            }
            ret.add(new BasicNameValuePair(key, String.valueOf(value)));
        }
        return ret;
    }

    public static List<Header> buildHeadersFromMap(Map<String, ?> headerMap) {
        if (MapUtils.isEmpty(headerMap)) {
            return null;
        }
        ArrayList<Header> ret = Lists.newArrayList();
        for (Map.Entry<String, ?> e : headerMap.entrySet()) {
            String key = e.getKey();
            Object value = e.getValue();
            if (value == null) continue;
            if (value instanceof Collection) {
                Collection coll = (Collection)value;
                if (!CollectionUtils.isNotEmpty((Collection)coll)) continue;
                for (Object var : coll) {
                    ret.add(new BasicHeader(key, String.valueOf(var)));
                }
                continue;
            }
            if (value instanceof Object[]) {
                Object[] objs = (Object[])value;
                if (!ArrayUtils.isNotEmpty((Object[])objs)) continue;
                for (Object var : objs) {
                    ret.add(new BasicHeader(key, String.valueOf(var)));
                }
                continue;
            }
            ret.add(new BasicHeader(key, String.valueOf(value)));
        }
        return ret;
    }

    public static String getDomainByURI(URI uri) {
        return SignUtils.getDomainByURI((URI)uri);
    }

    public static Map<String, List<String>> getReqParamByUriQuerys(URI uri, List<String> querys, Map<String, List<String>> reqParams) {
        return SignUtils.getReqParamByUriQuerys((URI)uri, querys, reqParams);
    }
}

