/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.cloud.bean;

import com.yonyou.cloud.middleware.rpc.RemoteCall;

public class RemoteCallInfo {
    String appCode;
    String nameSpace = System.getProperty("default.namespace", "c87e2267-1001-4c70-bb2a-ab41f3b81aa3");
    String alias;
    String version;
    String className;

    public RemoteCallInfo() {
    }

    public RemoteCallInfo(Class<?> cls) {
        RemoteCall rpcinfo = cls.getAnnotation(RemoteCall.class);
        String[] rval = rpcinfo.value().split("@");
        this.appCode = rval[0];
        if (rval.length == 2) {
            this.nameSpace = rval[1];
        }
        this.className = cls.getName();
        this.alias = rpcinfo.alias();
        this.version = rpcinfo.version();
    }

    public String getKey() {
        return RemoteCallInfo.sign(this.appCode, this.nameSpace, this.className);
    }

    public String getAliasKey() {
        return RemoteCallInfo.sign(this.appCode, this.nameSpace, this.alias);
    }

    public static String sign(String appCode, String nameSpace, String alias) {
        return appCode + "@" + nameSpace + ":" + alias;
    }

    public String getAppUniqName() {
        return this.appCode + "@" + this.nameSpace;
    }

    public String getAppQName() {
        return this.appCode + "-" + this.nameSpace;
    }

    public String getAppCode() {
        return this.appCode;
    }

    public void setAppCode(String appCode) {
        this.appCode = appCode;
    }

    public String getNameSpace() {
        return this.nameSpace;
    }

    public void setNameSpace(String nameSpace) {
        if (nameSpace != null && nameSpace.length() > 0) {
            this.nameSpace = nameSpace;
        }
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public Class<?> getInterface() {
        try {
            return Class.forName(this.className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }
}

