/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.cloud.exception;

import com.yonyou.cloud.exception.PluginExceptionHandler;
import java.io.PrintStream;
import java.io.PrintWriter;

public class PluginRuntimeException
extends RuntimeException {
    private static final long serialVersionUID = -8619780284226066564L;
    private Integer errorCode;
    private String errorPlugin;
    private Boolean needInterrupt;
    private String stack;

    public void setErrorCode(Integer errorCode) {
        this.errorCode = errorCode;
    }

    public String getErrorPlugin() {
        return this.errorPlugin;
    }

    public void setErrorPlugin(String errorPlugin) {
        this.errorPlugin = errorPlugin;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public boolean isNeedInterrupt() {
        return this.needInterrupt;
    }

    public void setNeedInterrupt(Boolean needInterrupt) {
        this.needInterrupt = needInterrupt;
    }

    public PluginRuntimeException(Integer errorCode, String errorMsg, String errorPlugin) {
        super(errorMsg);
        this.errorCode = errorCode;
        this.errorPlugin = errorPlugin;
        this.needInterrupt = false;
        this.stack = null;
    }

    public PluginRuntimeException(Integer errorCode, String errorMsg, String errorPlugin, Boolean needInterrupt) {
        super(errorMsg);
        this.errorCode = errorCode;
        this.errorPlugin = errorPlugin;
        this.needInterrupt = needInterrupt;
        this.stack = null;
    }

    public PluginRuntimeException(Integer errorCode, String errorMsg, Throwable cause, String errorPlugin) {
        super(errorMsg);
        this.errorCode = errorCode;
        this.errorPlugin = errorPlugin;
        this.needInterrupt = false;
        if (errorMsg == null) {
            errorMsg = "";
        }
        this.stack = errorMsg + "\n";
        this.stack = this.stack + PluginExceptionHandler.getStackTrace(cause);
    }

    public PluginRuntimeException(Integer errorCode, String errorMsg, Throwable cause, String errorPlugin, Boolean needInterrupt) {
        super(errorMsg);
        this.errorCode = errorCode;
        this.errorPlugin = errorPlugin;
        this.needInterrupt = needInterrupt;
        if (errorMsg == null) {
            errorMsg = "";
        }
        this.stack = errorMsg + "\n";
        this.stack = this.stack + PluginExceptionHandler.getStackTrace(cause);
    }

    @Override
    public void printStackTrace(PrintStream s) {
        if (this.stack != null) {
            s.println(this.stack);
        } else {
            super.printStackTrace(s);
        }
    }

    @Override
    public void printStackTrace(PrintWriter s) {
        if (this.stack != null) {
            s.println(this.stack);
        } else {
            super.printStackTrace(s);
        }
    }
}

