/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.cloud.filter;

import com.yonyou.cloud.middleware.iris.RPCInvocationInfoProxy;
import com.yonyou.cloud.utils.StringUtils;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ZoneFilter
implements Filter {
    private final String ZONE_KEY = "zone";
    private String sessionZone;
    private long readTimeout;
    private long writeTimeout;
    private final long defaultReadTimeout = 30000L;
    private final long defaultWriteTimeout = 60000L;

    public void init(FilterConfig filterConfig) throws ServletException {
        String readTimeoutStr = filterConfig.getInitParameter("readTimeout");
        String writeTimeoutStr = filterConfig.getInitParameter("writeTimeout");
        this.readTimeout = StringUtils.isNotBlank(readTimeoutStr) ? Long.parseLong(readTimeoutStr) : 30000L;
        this.writeTimeout = StringUtils.isNotBlank(writeTimeoutStr) ? Long.parseLong(writeTimeoutStr) : 60000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        Cookie[] cookies = httpRequest.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!"zone".equalsIgnoreCase(cookie.getName())) continue;
                this.sessionZone = cookie.getValue();
                break;
            }
        }
        String createCookie = httpRequest.getParameter("createCookie");
        Cookie cookie = null;
        if (this.sessionZone == null && StringUtils.isNoneBlank(createCookie)) {
            cookie = new Cookie("zone", createCookie);
            httpResponse.addCookie(cookie);
        }
        RPCInvocationInfoProxy.setReadTimeout(this.readTimeout);
        RPCInvocationInfoProxy.setWriteTimeout(this.writeTimeout);
        RPCInvocationInfoProxy.setInstanceZone(this.sessionZone);
        try {
            chain.doFilter((ServletRequest)httpRequest, response);
        }
        finally {
            this.sessionZone = null;
            RPCInvocationInfoProxy.reset();
        }
    }

    public void destroy() {
    }

    public String getSessionZone() {
        return this.sessionZone;
    }
}

