/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.cloud.iceberg;

import com.yonyou.cloud.iceberg.jar.Handler;
import com.yonyou.cloud.iceberg.jar.JarFile;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;

public class LaunchedURLClassLoader
extends URLClassLoader {
    private ClassLoader externloder;

    public LaunchedURLClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, (ClassLoader)null);
        this.externloder = parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URL findResource(String name) {
        Handler.setUseFastConnectionExceptions(true);
        try {
            URL resource_url = super.findResource(name);
            if (null == resource_url) {
                resource_url = this.externloder.getResource(name);
            }
            URL uRL = resource_url;
            return uRL;
        }
        finally {
            Handler.setUseFastConnectionExceptions(false);
        }
    }

    @Override
    public Enumeration<URL> findResources(String name) throws IOException {
        Handler.setUseFastConnectionExceptions(true);
        try {
            Enumeration<URL> enumeration = super.findResources(name);
            return enumeration;
        }
        finally {
            Handler.setUseFastConnectionExceptions(false);
        }
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Handler.setUseFastConnectionExceptions(true);
        try {
            block11: {
                try {
                    this.definePackageIfNecessary(name);
                }
                catch (IllegalArgumentException ex) {
                    if (this.getPackage(name) != null) break block11;
                    throw new AssertionError((Object)("Package " + name + " has already been defined but it could not be found"));
                }
            }
            Class<?> c = null;
            try {
                c = super.loadClass(name, resolve);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (c == null && null != this.externloder) {
                c = this.externloder.loadClass(name);
                if (resolve) {
                    this.resolveClass(c);
                }
            }
            if (c != null) {
                Class<?> clazz = c;
                return clazz;
            }
            throw new ClassNotFoundException(name);
        }
        finally {
            Handler.setUseFastConnectionExceptions(false);
        }
    }

    private void definePackageIfNecessary(String className) {
        block3: {
            String packageName;
            int lastDot = className.lastIndexOf(46);
            if (lastDot >= 0 && this.getPackage(packageName = className.substring(0, lastDot)) == null) {
                try {
                    this.definePackage(className, packageName);
                }
                catch (IllegalArgumentException ex) {
                    if (this.getPackage(packageName) != null) break block3;
                    throw new AssertionError((Object)("Package " + packageName + " has already been defined but it could not be found"));
                }
            }
        }
    }

    private void definePackage(final String className, final String packageName) {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    String packageEntryName = packageName.replace('.', '/') + "/";
                    String classEntryName = className.replace('.', '/') + ".class";
                    for (URL url : LaunchedURLClassLoader.this.getURLs()) {
                        try {
                            java.util.jar.JarFile jarFile;
                            URLConnection connection = url.openConnection();
                            if (!(connection instanceof JarURLConnection) || (jarFile = ((JarURLConnection)connection).getJarFile()).getEntry(classEntryName) == null || jarFile.getEntry(packageEntryName) == null || jarFile.getManifest() == null) continue;
                            LaunchedURLClassLoader.this.definePackage(packageName, jarFile.getManifest(), url);
                            return null;
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    return null;
                }
            }, AccessController.getContext());
        }
        catch (PrivilegedActionException privilegedActionException) {
            // empty catch block
        }
    }

    public void clearCache() {
        for (URL url : this.getURLs()) {
            try {
                URLConnection connection = url.openConnection();
                if (!(connection instanceof JarURLConnection)) continue;
                this.clearCache(connection);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void clearCache(URLConnection connection) throws IOException {
        java.util.jar.JarFile jarFile = ((JarURLConnection)connection).getJarFile();
        if (jarFile instanceof JarFile) {
            ((JarFile)jarFile).clearCache();
        }
    }
}

