/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.cloud.iceberg;

import com.yonyou.cloud.iceberg.LaunchedURLClassLoader;
import com.yonyou.cloud.iceberg.MainMethodRunner;
import com.yonyou.cloud.iceberg.archive.Archive;
import com.yonyou.cloud.iceberg.archive.ExplodedArchive;
import com.yonyou.cloud.iceberg.archive.JarFileArchive;
import com.yonyou.cloud.iceberg.jar.JarFile;
import com.yonyou.cloud.iceberg.util.SpringBootSign;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public abstract class Launcher {
    protected void launch(String[] args) throws Exception {
        JarFile.registerUrlProtocolHandler();
        ClassLoader classLoader = this.createClassLoader(this.getClassPathArchives());
        this.launch(args, this.getMainClass(), classLoader);
    }

    public ClassLoader getLibsLoader() throws Exception {
        JarFile.registerUrlProtocolHandler();
        return this.createClassLoader(this.getClassPathArchives());
    }

    protected ClassLoader createClassLoader(List<Archive> archives) throws Exception {
        ArrayList<URL> urls = new ArrayList<URL>(archives.size());
        for (Archive archive : archives) {
            urls.add(archive.getUrl());
        }
        return this.createClassLoader(urls.toArray(new URL[urls.size()]));
    }

    protected ClassLoader createClassLoader(URL[] urls) throws Exception {
        return new LaunchedURLClassLoader(urls, this.getClass().getClassLoader());
    }

    protected void launch(String[] args, String mainClass, ClassLoader classLoader) throws Exception {
        Thread.currentThread().setContextClassLoader(classLoader);
        this.createMainMethodRunner(mainClass, args, classLoader).run();
    }

    protected MainMethodRunner createMainMethodRunner(String mainClass, String[] args, ClassLoader classLoader) {
        return new MainMethodRunner(mainClass, args);
    }

    protected abstract String getMainClass() throws Exception;

    protected abstract List<Archive> getClassPathArchives() throws Exception;

    protected final Archive createArchive() throws Exception {
        String path;
        ProtectionDomain protectionDomain = this.getClass().getProtectionDomain();
        CodeSource codeSource = protectionDomain.getCodeSource();
        URI location = codeSource == null ? null : codeSource.getLocation().toURI();
        String string = path = location == null ? null : location.getSchemeSpecificPart();
        if (path == null) {
            throw new IllegalStateException("Unable to determine code source archive");
        }
        File root = new File(path);
        if (!(root.exists() || (root = this.getSpringBootJarFile(path)) != null && root.exists())) {
            throw new IllegalStateException("Unable to determine code source archive from " + root);
        }
        return root.isDirectory() ? new ExplodedArchive(root) : new JarFileArchive(root);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File getSpringBootJarFile(String path) throws URISyntaxException, ZipException, IOException {
        URI location = new URI(path);
        String nestpath = location == null ? null : location.getSchemeSpecificPart();
        int endindex = nestpath.indexOf("jar!");
        nestpath = nestpath.substring(0, endindex + 3);
        File nestjar = new File(nestpath);
        ZipFile file = new ZipFile(nestjar);
        Enumeration<? extends ZipEntry> list = file.entries();
        int byteCount = 0;
        byte[] buffer = new byte[10240];
        FileOutputStream outputStream = null;
        InputStream in = null;
        File result = null;
        try {
            while (list.hasMoreElements()) {
                ZipEntry entry = list.nextElement();
                String name = entry.getName();
                if (!name.contains("middleware") || !name.endsWith("jar")) continue;
                outputStream = new FileOutputStream("middleware-spring-boot.jar");
                in = file.getInputStream(entry);
                while ((byteCount = in.read(buffer)) != -1) {
                    outputStream.write(buffer, 0, byteCount);
                }
                result = new File("middleware-spring-boot.jar");
                if (!this.checkMiddleWareJar(result)) continue;
                SpringBootSign.supportFlag = true;
                break;
            }
        }
        finally {
            if (outputStream != null) {
                outputStream.close();
            }
            if (in != null) {
                in.close();
            }
        }
        if (SpringBootSign.supportFlag) {
            return result;
        }
        return null;
    }

    private boolean checkMiddleWareJar(File file) throws ZipException, IOException {
        ZipFile zipresult = new ZipFile(file);
        Enumeration<? extends ZipEntry> list = zipresult.entries();
        while (list.hasMoreElements()) {
            ZipEntry entry = list.nextElement();
            String name = entry.getName();
            if (!name.contains("BOOT-INF") || !entry.isDirectory()) continue;
            return true;
        }
        return false;
    }
}

