/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.cloud.initializer;

import com.yonyou.cloud.filter.ZoneFilter;
import com.yonyou.cloud.initializer.IrisCommonInitializer;
import com.yonyou.cloud.middleware.AppRuntimeEnvironment;
import com.yonyou.cloud.middleware.rpc.RpcInvokerServlet;
import com.yonyou.cloud.mwclient.MwClientStartUp;
import java.util.Set;
import javax.servlet.FilterRegistration;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.annotation.HandlesTypes;

@HandlesTypes(value={IrisCommonInitializer.class})
public class IrisSpringInitializer
implements ServletContainerInitializer {
    public static final String CONTEXT_CLASS_PARAM = "contextClass";
    public static final String CONTEXT_CLASS_NAME = "com.yonyou.cloud.init.IrisBeanLoader";

    public void onStartup(Set<Class<?>> Irisiniters, ServletContext ctx) throws ServletException {
        if (ctx != null && !MwClientStartUp.isSpringboot()) {
            ctx.setInitParameter(CONTEXT_CLASS_PARAM, CONTEXT_CLASS_NAME);
            AppRuntimeEnvironment.context = ctx.getContextPath();
            this.regServServlet(ctx);
            this.regZoneFilter(ctx);
            AppRuntimeEnvironment.setServlet_context(ctx);
        }
        try {
            if (!MwClientStartUp.getstatus()) {
                MwClientStartUp.starup();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void regServServlet(ServletContext servletContext) {
        try {
            ServletRegistration servlet = servletContext.getServletRegistration("remoteCallInvokerServlet");
            if (servlet == null) {
                servlet = servletContext.addServlet("remoteCallInvokerServlet", RpcInvokerServlet.class);
                servlet.setInitParameter("alone", "true");
                servlet.addMapping(new String[]{"/CloudRemoteCall/*"});
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void regZoneFilter(ServletContext servletContext) {
        try {
            FilterRegistration filter = servletContext.getFilterRegistration("zoneFilter");
            if (filter == null) {
                filter = servletContext.addFilter("zoneFilter", ZoneFilter.class);
                filter.addMappingForUrlPatterns(null, false, new String[]{"/*"});
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

