/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.cloud.middleware;

import com.yonyou.cloud.middleware.AppRuntimeEnvironment;
import com.yonyou.cloud.middleware.model.ILogFactory;
import com.yonyou.cloud.middleware.model.ILogger;
import com.yonyou.cloud.mw.MwLocator;
import com.yonyou.cloud.mwclient.IInitServicePort;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Environment {
    static final ILogger logger = MwLocator.lookup(ILogFactory.class).getLogger(Environment.class);
    private String appId;
    private String providerId;
    private String accessKey;
    private String accessSecret;
    private String context;
    private String profile;
    private int port = 8080;
    private List<String> domains;
    private boolean sslEnabled;
    private boolean rpc_retry = false;
    private int rpc_retry_times = 3;
    private String zone;
    private Map<String, String> metainfo = new HashMap<String, String>();
    private String proteus_scan_package;

    private Environment(String appId, String providerId, String accessKey, String accessSecret, String context, String profile, String port, List<String> appDomains, String sslEnabled, String zone, String rpc_retry, String rpc_retry_times, String proteus_scan_package) {
        this.appId = appId;
        this.providerId = providerId;
        this.accessKey = accessKey;
        this.accessSecret = accessSecret;
        this.profile = profile == null ? "dev" : profile;
        this.context = context;
        this.domains = appDomains;
        this.zone = zone;
        if (sslEnabled != null) {
            this.sslEnabled = Boolean.valueOf(sslEnabled);
        }
        if (rpc_retry != null) {
            this.rpc_retry = Boolean.valueOf(rpc_retry);
        }
        if (rpc_retry_times != null) {
            this.rpc_retry_times = Integer.valueOf(rpc_retry_times);
        }
        if (proteus_scan_package != null) {
            this.proteus_scan_package = proteus_scan_package;
        }
        IInitServicePort tools = MwLocator.lookup(IInitServicePort.class);
        try {
            this.port = tools.SetPort(AppRuntimeEnvironment.getServlet_context(), port);
        }
        catch (Throwable e) {
            logger.error("Environment ser port error", e);
        }
    }

    String getAppId() {
        return this.appId;
    }

    String getProviderId() {
        return this.providerId;
    }

    String getAccessKey() {
        return this.accessKey;
    }

    String getAccessSecret() {
        return this.accessSecret;
    }

    public String getContext() {
        return this.context;
    }

    String getProfile() {
        return this.profile;
    }

    int getPort() {
        return this.port;
    }

    public List<String> getDomains() {
        return this.domains;
    }

    public void setDomains(List<String> domains) {
        this.domains = domains;
    }

    public boolean isSslEnabled() {
        return this.sslEnabled;
    }

    public void setSslEnabled(boolean sslEnabled) {
        this.sslEnabled = sslEnabled;
    }

    public String getZone() {
        return this.zone;
    }

    public void setZone(String zone) {
        this.zone = zone;
    }

    public Map<String, String> getMetainfo() {
        return this.metainfo;
    }

    public String getMetainfo(String key) {
        return this.metainfo.get(key);
    }

    public boolean isRpc_retry() {
        return this.rpc_retry;
    }

    public void setRpc_retry(boolean rpc_retry) {
        this.rpc_retry = rpc_retry;
    }

    public int getRpc_retry_times() {
        return this.rpc_retry_times;
    }

    public void setRpc_retry_times(int rpc_retry_times) {
        this.rpc_retry_times = rpc_retry_times;
    }

    public String getProteus_scan_package() {
        return this.proteus_scan_package;
    }

    public void setProteus_scan_package(String proteus_scan_package) {
        this.proteus_scan_package = proteus_scan_package;
    }
}

