/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.cloud.middleware.embed.proteus.client.common.restful.core;

import com.yonyou.cloud.middleware.model.ILogger;
import com.yonyou.cloud.middleware.model.MwLogFactory;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class RemoteUrl {
    private String url;
    private List<String> serverList;
    private List<URL> urls = new ArrayList<URL>();
    protected static final ILogger LOGGER = MwLogFactory.getLogger(RemoteUrl.class);

    public RemoteUrl(String url, List<String> serverList) {
        this.url = url;
        this.serverList = serverList;
        for (String server : serverList) {
            try {
                if (!server.contains("http://") && !server.contains("https://")) {
                    server = "http://" + server;
                }
                this.urls.add(new URL(server + url));
            }
            catch (MalformedURLException e) {
                LOGGER.error(e.toString());
            }
        }
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public List<String> getServerList() {
        return this.serverList;
    }

    public void setServerList(List<String> serverList) {
        this.serverList = serverList;
    }

    public List<URL> getUrls() {
        return this.urls;
    }

    public String toString() {
        return "RemoteUrl [url=" + this.url + ", serverList=" + this.serverList + ", urls=" + this.urls + "]";
    }
}

