/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.cloud.middleware.embed.proteus.client.common.restful.retry.impl;

import com.yonyou.cloud.middleware.embed.proteus.client.common.restful.core.UnreliableInterface;
import com.yonyou.cloud.middleware.embed.proteus.client.common.restful.retry.RetryStrategy;
import com.yonyou.cloud.middleware.model.ILogger;
import com.yonyou.cloud.middleware.model.MwLogFactory;

public class RetryStrategyRoundBin
implements RetryStrategy {
    protected static final ILogger LOGGER = MwLogFactory.getLogger(RetryStrategyRoundBin.class);

    @Override
    public <T> T retry(UnreliableInterface unreliableImpl, int retryTimes, int sleepSeconds) throws Exception {
        for (int cur_time = 0; cur_time < retryTimes; ++cur_time) {
            try {
                return unreliableImpl.call();
            }
            catch (Exception e) {
                LOGGER.warn("cannot reach, will retry " + cur_time + " .... " + e.toString());
                try {
                    Thread.sleep((long)sleepSeconds * 1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
        }
        LOGGER.warn("finally failed....");
        throw new Exception();
    }
}

