/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.cloud.middleware.embed.proteus.client.common.restful.type;

import com.yonyou.cloud.middleware.embed.proteus.client.common.restful.core.UnreliableInterface;
import com.yonyou.cloud.middleware.embed.proteus.client.utils.OsUtil;
import com.yonyou.cloud.middleware.model.ILogger;
import com.yonyou.cloud.middleware.model.MwLogFactory;
import com.yonyou.cloud.utils.FileUtils;
import java.io.File;
import java.net.URL;

public class FetchConfFile
implements UnreliableInterface {
    protected static final ILogger LOGGER = MwLogFactory.getLogger(FetchConfFile.class);
    private URL remoteUrl;
    private File localTmpFile;

    public FetchConfFile(URL remoteUrl, File localTmpFile) {
        this.remoteUrl = remoteUrl;
        this.localTmpFile = localTmpFile;
    }

    @Override
    public <T> T call() throws Exception {
        if (this.localTmpFile.exists()) {
            this.localTmpFile.delete();
        }
        LOGGER.debug("start to download. From: " + this.remoteUrl + " , TO: " + this.localTmpFile.getAbsolutePath());
        FileUtils.copyURLToFile(this.remoteUrl, this.localTmpFile);
        if (!OsUtil.isFileExist(this.localTmpFile.getAbsolutePath())) {
            throw new Exception("download is ok, but cannot find downloaded file." + this.localTmpFile);
        }
        LOGGER.debug("download success!  " + this.localTmpFile.getAbsolutePath());
        return null;
    }
}

