/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.cloud.middleware.embed.proteus.client.config;

import com.yonyou.cloud.middleware.embed.proteus.client.config.CustomClientConfig;
import com.yonyou.cloud.middleware.embed.proteus.client.config.DisClientConfig;
import com.yonyou.cloud.middleware.embed.proteus.client.context.ProteusConfContext;
import com.yonyou.cloud.middleware.model.ILogger;
import com.yonyou.cloud.middleware.model.MwLogFactory;
import com.yonyou.cloud.utils.StringUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CustomClientCfgHelper {
    private static final ILogger LOG = MwLogFactory.getLogger(CustomClientCfgHelper.class);
    private static String ValueCompare = null;
    private static int ValueComparerobin = 0;
    private static String StartupInterrput = null;

    public static CustomClientConfig getDefaultCfg() {
        if (ProteusConfContext.CustomClientConfigMap != null && ProteusConfContext.CustomClientConfigMap.size() == 1) {
            return ProteusConfContext.CustomClientConfigMap.get(0);
        }
        for (Map.Entry<String, CustomClientConfig> entry : ProteusConfContext.CustomClientConfigMap.entrySet()) {
            String master = entry.getValue().getMaster();
            if (!StringUtils.isNotBlank(master) || !"true".equals(master)) continue;
            return entry.getValue();
        }
        return null;
    }

    public static String getDefaultGroupName() {
        for (Map.Entry<String, CustomClientConfig> entry : ProteusConfContext.CustomClientConfigMap.entrySet()) {
            String master = entry.getValue().getMaster();
            if (!StringUtils.isNotBlank(master) || !"true".equals(master)) continue;
            return entry.getKey();
        }
        return "defaultGroup";
    }

    public static String getValueCompare() {
        if (!StringUtils.isBlank(ValueCompare)) {
            return ValueCompare;
        }
        for (Map.Entry<String, CustomClientConfig> entry : ProteusConfContext.CustomClientConfigMap.entrySet()) {
            String master = entry.getValue().getMaster();
            if (!StringUtils.isNotBlank(master) || !"true".equals(master)) continue;
            if ("true".equalsIgnoreCase(entry.getValue().getPros().getProperty("disconf.value.compare").trim())) {
                ValueCompare = "true";
            }
            return "true";
        }
        ValueCompare = "true";
        return "true";
    }

    public static String getStartupInterrput() {
        if (!StringUtils.isBlank(StartupInterrput)) {
            return StartupInterrput;
        }
        for (Map.Entry<String, CustomClientConfig> entry : ProteusConfContext.CustomClientConfigMap.entrySet()) {
            String master = entry.getValue().getMaster();
            if (!StringUtils.isNotBlank(master) || !"true".equals(master)) continue;
            if ("true".equalsIgnoreCase(entry.getValue().getPros().getProperty("disconf.startup.interrupt").trim())) {
                StartupInterrput = "true";
            }
            return "true";
        }
        StartupInterrput = "false";
        return "false";
    }

    public static int getValueCompareRobin() {
        if (ValueComparerobin != 0) {
            return ValueComparerobin;
        }
        for (Map.Entry<String, CustomClientConfig> entry : ProteusConfContext.CustomClientConfigMap.entrySet()) {
            String robinint;
            String master = entry.getValue().getMaster();
            if (!StringUtils.isNotBlank(master) || !"true".equals(master) || StringUtils.isBlank(robinint = entry.getValue().getPros().getProperty("disconf.value.compare.robin").trim())) continue;
            int tmp = Integer.valueOf(robinint);
            if (tmp == 0 || tmp < 0) {
                ValueComparerobin = Integer.valueOf("100");
                return ValueComparerobin;
            }
            ValueComparerobin = tmp;
            return ValueComparerobin;
        }
        ValueComparerobin = Integer.valueOf("100");
        return ValueComparerobin;
    }

    public static CustomClientConfig getCfgByGroupName(String groupName) {
        if ("defaultGroup".equals(groupName)) {
            return CustomClientCfgHelper.getDefaultCfg();
        }
        return ProteusConfContext.CustomClientConfigMap.get(groupName);
    }

    public static String getGroupIdByName(String groupName) {
        CustomClientConfig config = ProteusConfContext.CustomClientConfigMap.get(groupName);
        if (config != null) {
            return config.getGroupId();
        }
        return null;
    }

    public static CustomClientConfig getCfgByGroupId(String groupId) {
        for (Map.Entry<String, CustomClientConfig> entry : ProteusConfContext.CustomClientConfigMap.entrySet()) {
            String gid = entry.getValue().getGroupId();
            if (!StringUtils.isNotBlank(gid) || !gid.equals(groupId)) continue;
            return entry.getValue();
        }
        return null;
    }

    public static boolean isDisconfEnable(String group) {
        boolean isDisEnable = DisClientConfig.getInstance().ENABLE_DISCONF;
        if (StringUtils.isNotBlank(group) && !"defaultGroup".equals(group)) {
            boolean unable;
            CustomClientConfig cfg = CustomClientCfgHelper.getCfgByGroupName(group);
            String enableStr = cfg.getPros().getProperty("disconf.enable.remote.conf");
            boolean bl = unable = StringUtils.isNotEmpty(enableStr) && "false".equals(enableStr);
            if (unable) {
                isDisEnable = false;
            }
        }
        return isDisEnable;
    }

    public static boolean isWatchEnable(String group) {
        CustomClientConfig cfg;
        String watchAbleStr;
        boolean isWatchEnable = DisClientConfig.getInstance().WATCHABLE_DISCONF;
        if (StringUtils.isNotBlank(group) && !"defaultGroup".equals(group) && "false".equals(watchAbleStr = (cfg = CustomClientCfgHelper.getCfgByGroupName(group)).getPros().getProperty("disconf.watchable.remote.conf"))) {
            isWatchEnable = false;
        }
        return isWatchEnable;
    }

    public static String getApp(String groupCode) {
        String app = DisClientConfig.getInstance().APP;
        if (StringUtils.isNotBlank(groupCode) && !"defaultGroup".equals(groupCode)) {
            CustomClientConfig cfg = CustomClientCfgHelper.getCfgByGroupName(groupCode);
            if (cfg == null) {
                LOG.error("\u5206\u7ec4 {" + groupCode + "} \u5bf9\u5e94\u7684\u914d\u7f6e\u4fe1\u606f\u4e0d\u5b58\u5728\uff0c\u8bf7\u5728spring\u914d\u7f6e\u6587\u4ef6\u4e2d\u589e\u52a0\u5bf9\u5e94\u7684\u914d\u7f6e! ");
                throw new RuntimeException("\u914d\u7f6e\u4e2d\u5fc3\u5ba2\u6237\u7aef\uff0c\u5206\u7ec4\u914d\u7f6e\u4fe1\u606f\u4e0d\u5b8c\u6574!");
            }
            String appName = cfg.getPros().getProperty("disconf.app");
            if (!"null".equals(appName) && StringUtils.isNotBlank(appName)) {
                app = appName;
            }
        }
        return app;
    }

    public static String getEnv(String groupCode) {
        CustomClientConfig cfg;
        String env;
        String e = DisClientConfig.getInstance().ENV;
        if (StringUtils.isNotBlank(groupCode) && !"defaultGroup".equals(groupCode) && !"null".equals(env = (cfg = CustomClientCfgHelper.getCfgByGroupName(groupCode)).getPros().getProperty("disconf.env")) && StringUtils.isNotBlank(env)) {
            e = env;
        }
        return e;
    }

    public static String getVersion(String groupCode) {
        CustomClientConfig cfg;
        String version;
        String v = DisClientConfig.getInstance().VERSION;
        if (StringUtils.isNotBlank(groupCode) && !"defaultGroup".equals(groupCode) && !"null".equals(version = (cfg = CustomClientCfgHelper.getCfgByGroupName(groupCode)).getPros().getProperty("disconf.version")) && StringUtils.isNotBlank(version)) {
            v = version;
        }
        return v;
    }

    public static String getPollingInterval(String groupCode) {
        CustomClientConfig cfg;
        String pollingInterval;
        String pi = DisClientConfig.getInstance().POLLING_INTERVAL;
        if (StringUtils.isNotBlank(groupCode) && !"defaultGroup".equals(groupCode) && !"null".equals(pollingInterval = (cfg = CustomClientCfgHelper.getCfgByGroupName(groupCode)).getPros().getProperty("disconf.polling_interval")) && StringUtils.isNotBlank(pollingInterval)) {
            pi = pollingInterval;
        }
        return pi;
    }

    public static int getRetryTimes(String groupCode) {
        CustomClientConfig cfg;
        String retryTimes;
        int times = DisClientConfig.getInstance().CONF_SERVER_URL_RETRY_TIMES;
        if (StringUtils.isNotBlank(groupCode) && !"defaultGroup".equals(groupCode) && !"null".equals(retryTimes = (cfg = CustomClientCfgHelper.getCfgByGroupName(groupCode)).getPros().getProperty("disconf.conf_server_url_retry_times")) && StringUtils.isNotBlank(retryTimes)) {
            times = Integer.parseInt(retryTimes);
        }
        return times;
    }

    public static int getRetrySleepSeconds(String groupCode) {
        CustomClientConfig cfg;
        String secondsProp;
        int seconds = DisClientConfig.getInstance().confServerUrlRetrySleepSeconds;
        if (StringUtils.isNotBlank(groupCode) && !"defaultGroup".equals(groupCode) && !"null".equals(secondsProp = (cfg = CustomClientCfgHelper.getCfgByGroupName(groupCode)).getPros().getProperty("disconf.conf_server_url_retry_sleep_seconds")) && StringUtils.isNotBlank(secondsProp)) {
            seconds = Integer.parseInt(secondsProp);
        }
        return seconds;
    }

    public static String getUserDefineDownloadDir(String groupCode) {
        CustomClientConfig cfg;
        String userDir;
        String dir = DisClientConfig.getInstance().userDefineDownloadDir;
        if (StringUtils.isNotBlank(groupCode) && !"defaultGroup".equals(groupCode) && !"null".equals(userDir = (cfg = CustomClientCfgHelper.getCfgByGroupName(groupCode)).getPros().getProperty("disconf.user_define_download_dir")) && StringUtils.isNotBlank(userDir)) {
            dir = userDir;
        }
        return dir;
    }

    public static Set<String> getIgnoreSet(String groupCode) {
        HashSet<String> ignoreSet = new HashSet();
        String ignore = DisClientConfig.getInstance().IGNORE_DISCONF_LIST;
        if (StringUtils.isNotBlank(groupCode) && !"defaultGroup".equals(groupCode)) {
            List<String> ignoreDisconfList;
            CustomClientConfig cfg = CustomClientCfgHelper.getCfgByGroupName(groupCode);
            String userIgnore = cfg.getPros().getProperty("disconf.ignore");
            if (StringUtils.isNotBlank(userIgnore) && !"null".equals(userIgnore)) {
                ignore = userIgnore;
            }
            if ((ignoreDisconfList = StringUtils.parseStringToStringList(ignore, ",")) != null) {
                for (String ignoreData : ignoreDisconfList) {
                    ignoreSet.add(ignoreData.trim());
                }
            }
        } else {
            ignoreSet = DisClientConfig.getInstance().getIgnoreDisconfKeySet();
        }
        return ignoreSet;
    }

    public static String getUserConfServerUrl(String groupCode) {
        CustomClientConfig cfg;
        String paramsUrl;
        String url = DisClientConfig.getInstance().CONF_SERVER_HOST;
        if (StringUtils.isNotBlank(groupCode) && !"defaultGroup".equals(groupCode) && StringUtils.isNotBlank(paramsUrl = (cfg = CustomClientCfgHelper.getCfgByGroupName(groupCode)).getPros().getProperty("disconf.conf_server_host")) && !"null".equals(paramsUrl)) {
            url = paramsUrl;
        }
        return url;
    }

    public static boolean isDownloadDirInClassPathEnable(String group) {
        boolean isDowntoClassPathEnable = DisClientConfig.getInstance().enableLocalDownloadDirInClassPath;
        if (StringUtils.isNotBlank(group) && !"defaultGroup".equals(group)) {
            boolean unable;
            CustomClientConfig cfg = CustomClientCfgHelper.getCfgByGroupName(group);
            String enableStr = cfg.getPros().getProperty("disconf.enable_local_download_dir_in_class_path");
            boolean bl = unable = StringUtils.isNotEmpty(enableStr) && "false".equals(enableStr);
            if (unable) {
                isDowntoClassPathEnable = false;
            }
        }
        return isDowntoClassPathEnable;
    }
}

