/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.cloud.middleware.embed.proteus.client.config;

import com.yonyou.cloud.middleware.embed.proteus.client.config.inner.DisInnerConfigAnnotation;
import com.yonyou.cloud.middleware.embed.proteus.client.support.DisconfAutowareConfig;
import com.yonyou.cloud.middleware.model.ILogger;
import com.yonyou.cloud.middleware.model.MwLogFactory;
import com.yonyou.cloud.utils.StringUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public final class DisClientConfig {
    protected static final ILogger LOGGER = MwLogFactory.getLogger(DisClientConfig.class);
    protected static final DisClientConfig INSTANCE = new DisClientConfig();
    protected static final String filename = "disconf.properties";
    private boolean isLoaded = false;
    public static final String CONF_SERVER_HOST_NAME = "disconf.conf_server_host";
    @DisInnerConfigAnnotation(name="disconf.conf_server_host", defaultValue="DEFAULT_ENV")
    public String CONF_SERVER_HOST;
    private List<String> hostList;
    public static final String APP_NAME = "disconf.app";
    @DisInnerConfigAnnotation(name="disconf.app")
    public String APP;
    public static final String VERSION_NAME = "disconf.version";
    @DisInnerConfigAnnotation(name="disconf.version", defaultValue="DEFAULT_VERSION")
    public String VERSION = "DEFAULT_VERSION";
    @DisInnerConfigAnnotation(name="disconf.maintype")
    public String MAIN_TYPE;
    public static final String ENV_NAME = "disconf.env";
    @DisInnerConfigAnnotation(name="disconf.env", defaultValue="DEFAULT_ENV")
    public String ENV = "DEFAULT_ENV";
    public static final String ENABLE_REMOTE_CONF_NAME = "disconf.enable.remote.conf";
    @DisInnerConfigAnnotation(name="disconf.enable.remote.conf", defaultValue="true")
    public boolean ENABLE_DISCONF = true;
    public static final String WATCHABLE_REMOTE_CONF_NAME = "disconf.watchable.remote.conf";
    @DisInnerConfigAnnotation(name="disconf.watchable.remote.conf", defaultValue="false")
    public boolean WATCHABLE_DISCONF = false;
    @DisInnerConfigAnnotation(name="disconf.debug", defaultValue="false")
    public boolean DEBUG = false;
    public static final String IGNORE_NAME = "disconf.ignore";
    @DisInnerConfigAnnotation(name="disconf.ignore", defaultValue="")
    public String IGNORE_DISCONF_LIST = "";
    private Set<String> ignoreDisconfKeySet = new HashSet<String>();
    public static final String RETRY_TIMES_NAME = "disconf.conf_server_url_retry_times";
    @DisInnerConfigAnnotation(name="disconf.conf_server_url_retry_times", defaultValue="3")
    public int CONF_SERVER_URL_RETRY_TIMES = 3;
    public static final String USER_DEFINE_DOWNLOAD_DIR_NAME = "disconf.user_define_download_dir";
    @DisInnerConfigAnnotation(name="disconf.user_define_download_dir", defaultValue="./disconf/download")
    public String userDefineDownloadDir = "./disconf/download";
    public static final String RETRY_SLEEP_SECONDS_NAME = "disconf.conf_server_url_retry_sleep_seconds";
    @DisInnerConfigAnnotation(name="disconf.conf_server_url_retry_sleep_seconds", defaultValue="2")
    public int confServerUrlRetrySleepSeconds = 2;
    public static final String ENABLE_DOWNLOAD_CLASSPATH_NAME = "disconf.enable_local_download_dir_in_class_path";
    @DisInnerConfigAnnotation(name="disconf.enable_local_download_dir_in_class_path", defaultValue="true")
    public boolean enableLocalDownloadDirInClassPath = true;
    public static final String POLLING_INTERVAL_NAME = "disconf.polling_interval";
    @DisInnerConfigAnnotation(name="disconf.polling_interval")
    public String POLLING_INTERVAL;
    @DisInnerConfigAnnotation(name="disconf.value.compare", defaultValue="true")
    public String VALUE_COMPARE;
    @DisInnerConfigAnnotation(name="disconf.value.compare.robin", defaultValue="100")
    public String VALUE_COMPARE_ROBIN;
    @DisInnerConfigAnnotation(name="disconf.startup.interrupt", defaultValue="false")
    public String STARTUP_INTERRUPT;

    public static DisClientConfig getInstance() {
        return INSTANCE;
    }

    private DisClientConfig() {
    }

    public synchronized boolean isLoaded() {
        return this.isLoaded;
    }

    public synchronized void loadConfig(String filePath) throws Exception {
        if (this.isLoaded) {
            return;
        }
        String filePathInternal = filename;
        if (filePath != null) {
            filePathInternal = filePath;
        }
        try {
            DisconfAutowareConfig.autowareConfig((Object)INSTANCE, filePathInternal);
        }
        catch (Exception e) {
            LOGGER.warn("cannot find " + filePathInternal + ", using sys var or user input.");
        }
        DisconfAutowareConfig.autowareConfigWithSystemEnv(INSTANCE);
        this.isLoaded = true;
    }

    public synchronized void loadConfigByPros(Properties pros) throws Exception {
        DisconfAutowareConfig.autowareConfig((Object)INSTANCE, pros);
        DisconfAutowareConfig.autowareConfigWithSystemEnv(INSTANCE);
        this.isLoaded = true;
    }

    public List<String> getHostList() {
        return this.hostList;
    }

    public void setHostList(List<String> hostList) {
        this.hostList = hostList;
    }

    public Set<String> getIgnoreDisconfKeySet() {
        return this.ignoreDisconfKeySet;
    }

    public void setIgnoreDisconfKeySet(Set<String> ignoreDisconfKeySet) {
        this.ignoreDisconfKeySet = ignoreDisconfKeySet;
    }

    public int getValueCompareRobin() {
        int ValueComparerobin = 0;
        if (!StringUtils.isBlank(this.VALUE_COMPARE_ROBIN)) {
            int tmp = Integer.valueOf(this.VALUE_COMPARE_ROBIN);
            if (tmp == 0 || tmp < 0) {
                ValueComparerobin = Integer.valueOf("100");
                return ValueComparerobin;
            }
            ValueComparerobin = tmp;
            return ValueComparerobin;
        }
        ValueComparerobin = Integer.valueOf("100");
        return ValueComparerobin;
    }
}

