/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.cloud.middleware.embed.proteus.client.config.inner;

import com.yonyou.cloud.middleware.embed.proteus.client.common.model.InstanceFingerprint;
import com.yonyou.cloud.middleware.model.ILogger;
import com.yonyou.cloud.middleware.model.MwLogFactory;
import com.yonyou.cloud.utils.StringUtils;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.UUID;

public class DisClientComConfig {
    protected static final ILogger LOGGER = MwLogFactory.getLogger(DisClientComConfig.class);
    protected static final DisClientComConfig INSTANCE = new DisClientComConfig();
    private InstanceFingerprint instanceFingerprint;

    public static DisClientComConfig getInstance() {
        return INSTANCE;
    }

    private DisClientComConfig() {
        this.initInstanceFingerprint();
    }

    private void initInstanceFingerprint() {
        int port = 0;
        String host = DisClientComConfig.resolveSystemProperty("HOST");
        if (host == null) {
            try {
                InetAddress addr = InetAddress.getLocalHost();
                host = addr.getHostName();
            }
            catch (UnknownHostException e) {
                LOGGER.info("can not find host from system property!");
            }
        } else {
            try {
                port = Integer.parseInt(DisClientComConfig.resolveSystemProperty("PORT"));
            }
            catch (Exception e) {
                LOGGER.info("can not get port from system property!");
            }
        }
        this.instanceFingerprint = new InstanceFingerprint(host, port, UUID.randomUUID().toString());
    }

    public String getInstanceFingerprint() {
        return this.instanceFingerprint.getHost() + "_" + String.valueOf(this.instanceFingerprint.getPort()) + "_" + this.instanceFingerprint.getUuid();
    }

    private static String resolveSystemProperty(String key) {
        try {
            String value = System.getProperty(key);
            if (StringUtils.isBlank(value)) {
                value = System.getenv(key);
            }
            return value;
        }
        catch (Exception ex) {
            LOGGER.debug("Could not get system property '" + key + "': " + ex);
            return null;
        }
    }
}

