/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.cloud.middleware.embed.proteus.client.scan.inner.common;

import com.yonyou.cloud.middleware.embed.proteus.client.common.annotations.DisconfFile;
import com.yonyou.cloud.middleware.embed.proteus.client.common.constants.SupportFileTypeEnum;
import com.yonyou.cloud.middleware.embed.proteus.client.common.update.IDisconfUpdate;
import com.yonyou.cloud.middleware.model.ILogger;
import com.yonyou.cloud.middleware.model.MwLogFactory;

public class ScanVerify {
    protected static final ILogger LOGGER = MwLogFactory.getLogger(ScanVerify.class);

    public static boolean hasIDisconfUpdate(Class<?> disconfUpdateServiceClass) {
        Class<?>[] interfaceClasses = disconfUpdateServiceClass.getInterfaces();
        boolean hasInterface = false;
        for (Class<?> infClass : interfaceClasses) {
            if (!infClass.equals(IDisconfUpdate.class)) continue;
            hasInterface = true;
        }
        if (!hasInterface) {
            LOGGER.error("Your class " + disconfUpdateServiceClass.toString() + " should implement interface: " + IDisconfUpdate.class.toString());
            return false;
        }
        return true;
    }

    public static boolean isDisconfFileTypeRight(DisconfFile disconfFile) {
        String fileName = disconfFile.filename();
        SupportFileTypeEnum supportFileTypeEnum = SupportFileTypeEnum.getByFileName(fileName);
        if (supportFileTypeEnum == null) {
            LOGGER.error("now we only support this type of conf: " + disconfFile.toString());
            return false;
        }
        return true;
    }
}

