/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.cloud.middleware.embed.proteus.client.store.inner;

import com.yonyou.cloud.middleware.embed.proteus.client.common.model.DisconfCenterBaseModel;
import com.yonyou.cloud.middleware.embed.proteus.client.common.model.DisconfCenterFile;
import com.yonyou.cloud.middleware.embed.proteus.client.common.model.DisconfCenterItem;
import com.yonyou.cloud.middleware.embed.proteus.client.common.update.IDisconfUpdatePipeline;
import com.yonyou.cloud.middleware.embed.proteus.client.config.CustomClientCfgHelper;
import com.yonyou.cloud.middleware.embed.proteus.client.store.inner.model.ConfGroup;
import com.yonyou.cloud.middleware.model.ILogger;
import com.yonyou.cloud.middleware.model.MwLogFactory;
import com.yonyou.cloud.utils.StringUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DisconfCenterStore {
    protected static final ILogger LOGGER = MwLogFactory.getLogger(DisconfCenterStore.class);
    private List<String> activeBackupKeyList;
    private Map<String, ConfGroup> confGroupMap = new HashMap<String, ConfGroup>();
    private IDisconfUpdatePipeline iDisconfUpdatePipeline = null;
    private String machineName;

    private DisconfCenterStore() {
    }

    public static DisconfCenterStore getInstance() {
        return SingletonHolder.instance;
    }

    public Map<String, ConfGroup> getConfGroupMap() {
        return this.confGroupMap;
    }

    public void storeOneFile(DisconfCenterBaseModel disconfCenterBaseModel) {
        ConfGroup cg;
        DisconfCenterFile disconfCenterFile = (DisconfCenterFile)disconfCenterBaseModel;
        String fileName = disconfCenterFile.getFileName();
        String group = disconfCenterFile.getGroup();
        if (StringUtils.isBlank(group) || "null".equals(group)) {
            group = CustomClientCfgHelper.getDefaultGroupName();
        }
        if (this.confGroupMap.get(group) == null) {
            ConfGroup confGroup = new ConfGroup();
            this.confGroupMap.put(group, confGroup);
        }
        if ((cg = this.confGroupMap.get(group)).getConfFileMap().containsKey(fileName)) {
            LOGGER.error("There are two same fileName in group[" + group + "]!!!!first: " + cg.getConfFileMap().get(fileName).toString() + ", Second: " + disconfCenterFile.toString());
        } else {
            cg.getConfFileMap().put(fileName, disconfCenterFile);
        }
    }

    public void storeOneItem(DisconfCenterBaseModel disconfCenterBaseModel) {
        ConfGroup cg;
        DisconfCenterItem disconfCenterItem = (DisconfCenterItem)disconfCenterBaseModel;
        String key = disconfCenterItem.getKey();
        String group = disconfCenterItem.getGroup();
        if (StringUtils.isBlank(group) || "null".equals(group)) {
            group = CustomClientCfgHelper.getDefaultGroupName();
        }
        if (this.confGroupMap.get(group) == null) {
            ConfGroup confGroup = new ConfGroup();
            this.confGroupMap.put(group, confGroup);
        }
        if ((cg = this.confGroupMap.get(group)).getConfItemMap().containsKey(key)) {
            LOGGER.error("There are two same fileName in group[" + group + "]!!!! first: " + cg.getConfItemMap().get(key).getClass().toString() + ", Second: " + disconfCenterItem.getClass().toString());
        } else {
            cg.getConfItemMap().put(key, disconfCenterItem);
        }
    }

    public void excludeOneItem(String group, String key) {
        ConfGroup cg = this.confGroupMap.get(group);
        if (cg.getConfItemMap().containsKey(key)) {
            cg.getConfItemMap().remove(key);
        }
    }

    public void excludeOneFile(String group, String key) {
        ConfGroup cg = this.confGroupMap.get(group);
        if (cg.getConfFileMap().containsKey(key)) {
            cg.getConfFileMap().remove(key);
        }
    }

    public List<String> getActiveBackupKeyList() {
        return this.activeBackupKeyList;
    }

    public String getMachineName() {
        return this.machineName;
    }

    public void setMachineName(String machineName) {
        this.machineName = machineName;
    }

    public IDisconfUpdatePipeline getiDisconfUpdatePipeline() {
        return this.iDisconfUpdatePipeline;
    }

    public void setiDisconfUpdatePipeline(IDisconfUpdatePipeline iDisconfUpdatePipeline) {
        this.iDisconfUpdatePipeline = iDisconfUpdatePipeline;
    }

    private static class SingletonHolder {
        private static DisconfCenterStore instance = new DisconfCenterStore();

        private SingletonHolder() {
        }
    }
}

