/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.cloud.middleware.embed.proteus.client.store.processor.impl;

import com.yonyou.cloud.middleware.embed.proteus.client.addons.properties.ReloadConfigurationMonitor;
import com.yonyou.cloud.middleware.embed.proteus.client.common.constants.SupportFileTypeEnum;
import com.yonyou.cloud.middleware.embed.proteus.client.common.model.DisConfCommonModel;
import com.yonyou.cloud.middleware.embed.proteus.client.common.model.DisconfCenterBaseModel;
import com.yonyou.cloud.middleware.embed.proteus.client.common.model.DisconfCenterFile;
import com.yonyou.cloud.middleware.embed.proteus.client.common.update.IDisconfUpdate;
import com.yonyou.cloud.middleware.embed.proteus.client.store.DisconfStoreProcessor;
import com.yonyou.cloud.middleware.embed.proteus.client.store.inner.DisconfCenterStore;
import com.yonyou.cloud.middleware.embed.proteus.client.store.inner.model.ConfGroup;
import com.yonyou.cloud.middleware.embed.proteus.client.store.processor.model.DisconfValue;
import com.yonyou.cloud.middleware.model.ILogger;
import com.yonyou.cloud.middleware.model.MwLogFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DisconfStoreFileProcessorImpl
implements DisconfStoreProcessor {
    protected static final ILogger LOGGER = MwLogFactory.getLogger(DisconfStoreFileProcessorImpl.class);

    @Override
    public void addUpdateCallbackList(String group, String keyName, List<IDisconfUpdate> iDisconfUpdateList) {
        ConfGroup cg = DisconfCenterStore.getInstance().getConfGroupMap().get(group);
        if (cg.getConfFileMap().containsKey(keyName)) {
            cg.getConfFileMap().get(keyName).getDisconfCommonCallbackModel().getDisconfConfUpdates().addAll(iDisconfUpdateList);
        }
    }

    @Override
    public List<IDisconfUpdate> getUpdateCallbackList(String group, String keyName) {
        ConfGroup cg = DisconfCenterStore.getInstance().getConfGroupMap().get(group);
        if (cg.getConfFileMap().containsKey(keyName)) {
            return cg.getConfFileMap().get(keyName).getDisconfCommonCallbackModel().getDisconfConfUpdates();
        }
        return new ArrayList<IDisconfUpdate>();
    }

    @Override
    public DisConfCommonModel getCommonModel(String group, String keyName) {
        ConfGroup cg = DisconfCenterStore.getInstance().getConfGroupMap().get(group);
        DisconfCenterFile disconfCenterFile = cg.getConfFileMap().get(keyName);
        if (disconfCenterFile == null) {
            LOGGER.error("cannot find " + keyName + " in store....");
            return null;
        }
        return disconfCenterFile.getDisConfCommonModel();
    }

    @Override
    public boolean hasThisConf(String group, String keyName) {
        ConfGroup cg = DisconfCenterStore.getInstance().getConfGroupMap().get(group);
        return cg.getConfFileMap().containsKey(keyName);
    }

    @Override
    public void inject2Instance(Object object, String group, String fileName) {
        ConfGroup cg = DisconfCenterStore.getInstance().getConfGroupMap().get(group);
        DisconfCenterFile disconfCenterFile = cg.getConfFileMap().get(fileName);
        if (disconfCenterFile == null) {
            LOGGER.error("cannot find " + fileName + " in store....");
            return;
        }
        if (object != null) {
            disconfCenterFile.setObject(object);
        }
        Map<String, DisconfCenterFile.FileItemValue> keMap = disconfCenterFile.getKeyMaps();
        for (String fileItem : keMap.keySet()) {
            try {
                if (object == null) {
                    if (!keMap.get(fileItem).isStatic()) continue;
                    LOGGER.debug(fileItem + " is a static field. ");
                    keMap.get(fileItem).setValue4StaticFileItem(keMap.get(fileItem).getValue());
                    continue;
                }
                LOGGER.debug(fileItem + " is a non-static field. ");
                if (keMap.get(fileItem).getValue() == null) {
                    Object defaultValue = keMap.get(fileItem).getFieldDefaultValue(object);
                    keMap.get(fileItem).setValue(defaultValue);
                    continue;
                }
                keMap.get(fileItem).setValue4FileItem(object, keMap.get(fileItem).getValue());
            }
            catch (Exception e) {
                LOGGER.error("inject2Instance fileName " + fileName + " " + e.toString(), e);
            }
        }
    }

    @Override
    public Object getConfig(String group, String fileName, String keyName) {
        ConfGroup cg = DisconfCenterStore.getInstance().getConfGroupMap().get(group);
        DisconfCenterFile disconfCenterFile = cg.getConfFileMap().get(fileName);
        if (disconfCenterFile == null) {
            LOGGER.debug("cannot find " + fileName + " in store....");
            return null;
        }
        if (disconfCenterFile.getKeyMaps().get(keyName) == null) {
            LOGGER.debug("cannot find " + fileName + ", " + keyName + " in store....");
            return null;
        }
        return disconfCenterFile.getKeyMaps().get(keyName).getValue();
    }

    @Override
    public void inject2Store(String group, String fileName, DisconfValue disconfValue) {
        ConfGroup cg = DisconfCenterStore.getInstance().getConfGroupMap().get(group);
        DisconfCenterFile disconfCenterFile = cg.getConfFileMap().get(fileName);
        if (disconfCenterFile == null) {
            LOGGER.error("cannot find " + fileName + " in store....");
            return;
        }
        if (disconfValue == null || disconfValue.getFileData() == null) {
            LOGGER.error("value is null for {" + fileName + "}");
            return;
        }
        Map<String, DisconfCenterFile.FileItemValue> keMap = disconfCenterFile.getKeyMaps();
        if (keMap.size() > 0) {
            for (String fileItem : keMap.keySet()) {
                Object object = disconfValue.getFileData().get(fileItem);
                if (object == null) {
                    LOGGER.error("cannot find {" + fileItem + "} to be injected. file content is: {" + disconfValue.getFileData().toString() + "}");
                    continue;
                }
                try {
                    Object value = keMap.get(fileItem).getFieldValueByType(object);
                    keMap.get(fileItem).setValue(value);
                }
                catch (Exception e) {
                    LOGGER.error("inject2Store filename: " + fileName + " " + e.toString(), e);
                }
            }
        } else {
            if (disconfCenterFile.getObject() == null && disconfCenterFile.getSupportFileTypeEnum().equals((Object)SupportFileTypeEnum.PROPERTIES)) {
                ReloadConfigurationMonitor.reload();
            }
            disconfCenterFile.setAdditionalKeyMaps(disconfValue.getFileData());
        }
    }

    @Override
    public void transformScanData(List<DisconfCenterBaseModel> disconfCenterBaseModels) {
        for (DisconfCenterBaseModel disconfCenterFile : disconfCenterBaseModels) {
            this.transformScanData(disconfCenterFile);
        }
    }

    @Override
    public void transformScanData(DisconfCenterBaseModel disconfCenterBaseModel) {
        DisconfCenterStore.getInstance().storeOneFile(disconfCenterBaseModel);
    }

    @Override
    public DisconfCenterBaseModel getConfData(String group, String key) {
        ConfGroup cg = DisconfCenterStore.getInstance().getConfGroupMap().get(group);
        if (cg.getConfFileMap().containsKey(key)) {
            return cg.getConfFileMap().get(key);
        }
        return null;
    }

    @Override
    public Set<String> getConfKeySet(String group) {
        ConfGroup cg = DisconfCenterStore.getInstance().getConfGroupMap().get(group);
        return cg.getConfFileMap().keySet();
    }

    @Override
    public String confToString(String group) {
        ConfGroup cg = DisconfCenterStore.getInstance().getConfGroupMap().get(group);
        StringBuffer sBuffer = new StringBuffer();
        sBuffer.append("\n");
        Map<String, DisconfCenterFile> disMap = cg.getConfFileMap();
        for (String file : disMap.keySet()) {
            sBuffer.append("disconf-file:\t" + file + "\t");
            sBuffer.append(disMap.get(file).infoString());
            sBuffer.append("\n");
        }
        return sBuffer.toString();
    }

    @Override
    public void exclude(String group, Set<String> keySet) {
        for (String key : keySet) {
            DisconfCenterStore.getInstance().excludeOneFile(group, key);
        }
    }
}

