/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.cloud.middleware.embed.proteus.client.store.processor.impl;

import com.yonyou.cloud.middleware.embed.proteus.client.common.model.DisConfCommonModel;
import com.yonyou.cloud.middleware.embed.proteus.client.common.model.DisconfCenterBaseModel;
import com.yonyou.cloud.middleware.embed.proteus.client.common.model.DisconfCenterItem;
import com.yonyou.cloud.middleware.embed.proteus.client.common.update.IDisconfUpdate;
import com.yonyou.cloud.middleware.embed.proteus.client.store.DisconfStoreProcessor;
import com.yonyou.cloud.middleware.embed.proteus.client.store.inner.DisconfCenterStore;
import com.yonyou.cloud.middleware.embed.proteus.client.store.inner.model.ConfGroup;
import com.yonyou.cloud.middleware.embed.proteus.client.store.processor.model.DisconfValue;
import com.yonyou.cloud.middleware.model.ILogger;
import com.yonyou.cloud.middleware.model.MwLogFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DisconfStoreItemProcessorImpl
implements DisconfStoreProcessor {
    protected static final ILogger LOGGER = MwLogFactory.getLogger(DisconfStoreItemProcessorImpl.class);

    @Override
    public void addUpdateCallbackList(String group, String keyName, List<IDisconfUpdate> iDisconfUpdateList) {
        ConfGroup cg = DisconfCenterStore.getInstance().getConfGroupMap().get(group);
        if (cg.getConfItemMap().containsKey(keyName)) {
            cg.getConfItemMap().get(keyName).getDisconfCommonCallbackModel().getDisconfConfUpdates().addAll(iDisconfUpdateList);
        }
    }

    @Override
    public List<IDisconfUpdate> getUpdateCallbackList(String group, String keyName) {
        ConfGroup cg = DisconfCenterStore.getInstance().getConfGroupMap().get(group);
        if (cg.getConfItemMap().containsKey(keyName)) {
            return cg.getConfItemMap().get(keyName).getDisconfCommonCallbackModel().getDisconfConfUpdates();
        }
        return new ArrayList<IDisconfUpdate>();
    }

    @Override
    public DisConfCommonModel getCommonModel(String group, String keyName) {
        ConfGroup cg = DisconfCenterStore.getInstance().getConfGroupMap().get(group);
        DisconfCenterItem disconfCenterItem = cg.getConfItemMap().get(keyName);
        if (disconfCenterItem == null) {
            LOGGER.error("cannot find " + keyName + " in store....");
            return null;
        }
        return disconfCenterItem.getDisConfCommonModel();
    }

    @Override
    public boolean hasThisConf(String group, String keyName) {
        ConfGroup cg = DisconfCenterStore.getInstance().getConfGroupMap().get(group);
        return cg.getConfItemMap().containsKey(keyName);
    }

    @Override
    public void inject2Instance(Object object, String group, String key) {
        ConfGroup cg = DisconfCenterStore.getInstance().getConfGroupMap().get(group);
        DisconfCenterItem disconfCenterItem = cg.getConfItemMap().get(key);
        if (disconfCenterItem == null) {
            LOGGER.error("cannot find " + key + " in store....");
            return;
        }
        if (object != null) {
            disconfCenterItem.setObject(object);
        }
        try {
            if (object != null) {
                LOGGER.debug(disconfCenterItem.getKey() + " is a non-static field. ");
                if (disconfCenterItem.getValue() == null) {
                    Object defaultValue = disconfCenterItem.getFieldDefaultValue(object);
                    disconfCenterItem.setValue(defaultValue);
                } else {
                    disconfCenterItem.setValue4FileItem(object, disconfCenterItem.getValue());
                }
            } else if (disconfCenterItem.isStatic()) {
                LOGGER.debug(disconfCenterItem.getKey() + " is a static field. ");
                disconfCenterItem.setValue4StaticFileItem(disconfCenterItem.getValue());
            }
        }
        catch (Exception e) {
            LOGGER.error("inject2Instance key: " + key + " " + e.toString(), e);
        }
    }

    @Override
    public Object getConfig(String group, String fileName, String keyName) {
        ConfGroup cg = DisconfCenterStore.getInstance().getConfGroupMap().get(group);
        DisconfCenterItem disconfCenterItem = cg.getConfItemMap().get(keyName);
        if (disconfCenterItem == null) {
            LOGGER.debug("cannot find " + keyName + " in store....");
            return null;
        }
        return disconfCenterItem.getValue();
    }

    @Override
    public void inject2Store(String group, String key, DisconfValue disconfValue) {
        ConfGroup cg = DisconfCenterStore.getInstance().getConfGroupMap().get(group);
        DisconfCenterItem disconfCenterItem = cg.getConfItemMap().get(key);
        if (disconfCenterItem == null) {
            LOGGER.error("cannot find " + key + " in store....");
            return;
        }
        if (disconfValue == null || disconfValue.getValue() == null) {
            return;
        }
        try {
            Object newValue = disconfCenterItem.getFieldValueByType(disconfValue.getValue());
            disconfCenterItem.setValue(newValue);
        }
        catch (Exception e) {
            LOGGER.error("key: " + key + " " + e.toString(), e);
        }
    }

    @Override
    public void transformScanData(List<DisconfCenterBaseModel> disconfCenterBaseModels) {
        for (DisconfCenterBaseModel disconfCenterItem : disconfCenterBaseModels) {
            this.transformScanData(disconfCenterItem);
        }
    }

    @Override
    public void transformScanData(DisconfCenterBaseModel disconfCenterBaseModel) {
        DisconfCenterStore.getInstance().storeOneItem(disconfCenterBaseModel);
    }

    @Override
    public DisconfCenterBaseModel getConfData(String group, String key) {
        ConfGroup cg = DisconfCenterStore.getInstance().getConfGroupMap().get(group);
        if (cg.getConfItemMap().containsKey(key)) {
            return cg.getConfItemMap().get(key);
        }
        return null;
    }

    @Override
    public Set<String> getConfKeySet(String group) {
        ConfGroup cg = DisconfCenterStore.getInstance().getConfGroupMap().get(group);
        return cg.getConfItemMap().keySet();
    }

    @Override
    public String confToString(String group) {
        ConfGroup cg = DisconfCenterStore.getInstance().getConfGroupMap().get(group);
        StringBuilder sBuffer = new StringBuilder();
        sBuffer.append("\n");
        Map<String, DisconfCenterItem> disMap = cg.getConfItemMap();
        for (String file : disMap.keySet()) {
            sBuffer.append("disItem:\t" + file + "\t");
            sBuffer.append(disMap.get(file).infoString());
            sBuffer.append("\n");
        }
        return sBuffer.toString();
    }

    @Override
    public void exclude(String group, Set<String> keySet) {
        for (String key : keySet) {
            DisconfCenterStore.getInstance().excludeOneItem(group, key);
        }
    }
}

