/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.cloud.middleware.embed.proteus.client.support;

import com.yonyou.cloud.middleware.embed.proteus.client.common.annotations.DisconfFileItem;
import com.yonyou.cloud.middleware.embed.proteus.client.config.inner.DisInnerConfigAnnotation;
import com.yonyou.cloud.middleware.embed.proteus.client.utils.ConfigLoaderUtils;
import com.yonyou.cloud.middleware.embed.proteus.client.utils.FilenameUtils;
import com.yonyou.cloud.middleware.model.ILogger;
import com.yonyou.cloud.middleware.model.MwLogFactory;
import com.yonyou.cloud.utils.ClassUtils;
import com.yonyou.cloud.utils.StringUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Properties;

public final class DisconfAutowareConfig {
    protected static final ILogger LOGGER = MwLogFactory.getLogger(DisconfAutowareConfig.class);

    private DisconfAutowareConfig() {
    }

    private static Properties getProperties(String propertyFilePath) throws Exception {
        try {
            return ConfigLoaderUtils.loadConfig(propertyFilePath);
        }
        catch (Exception e) {
            String filename = FilenameUtils.getName(propertyFilePath);
            return ConfigLoaderUtils.loadConfig(filename);
        }
    }

    public static void autowareConfigWithSystemEnv(Object obj) throws Exception {
        try {
            Field[] fields;
            for (Field field : fields = obj.getClass().getDeclaredFields()) {
                if (!field.isAnnotationPresent(DisInnerConfigAnnotation.class) || Modifier.isStatic(field.getModifiers())) continue;
                DisInnerConfigAnnotation config = field.getAnnotation(DisInnerConfigAnnotation.class);
                String name = config.name();
                String value = DisconfAutowareConfig.resolveSystemEnvProperty(name);
                field.setAccessible(true);
                if (null == value) continue;
                try {
                    ClassUtils.setFieldValeByType(field, obj, value);
                }
                catch (Exception e) {
                    LOGGER.error(String.format("invalid config: %s", name), e);
                }
            }
        }
        catch (Exception e) {
            throw new Exception("error while autowareConfigWithSystemEnv autowire config file", e);
        }
    }

    private static String resolveSystemEnvProperty(String key) {
        try {
            String value = System.getProperty(key);
            if (StringUtils.isBlank(value)) {
                value = System.getenv(key);
            }
            return value;
        }
        catch (Exception ex) {
            LOGGER.debug("Could not access system property '" + key + "': " + ex);
            return null;
        }
    }

    public static void autowareConfig(Object obj, Properties prop) throws Exception {
        if (null == prop || obj == null) {
            throw new Exception("cannot autowareConfig null");
        }
        try {
            Field[] fields;
            for (Field field : fields = obj.getClass().getDeclaredFields()) {
                String value;
                String name;
                if (!field.isAnnotationPresent(DisconfFileItem.class) && !field.isAnnotationPresent(DisInnerConfigAnnotation.class) || Modifier.isStatic(field.getModifiers())) continue;
                if (field.isAnnotationPresent(DisconfFileItem.class)) {
                    name = field.getName();
                    value = prop.getProperty(name, null);
                } else {
                    String defaultValue;
                    DisInnerConfigAnnotation config = field.getAnnotation(DisInnerConfigAnnotation.class);
                    name = config.name();
                    value = prop.getProperty(name, defaultValue = config.defaultValue());
                    if (value.equals(defaultValue) && name != null && name.contains("disconf.")) {
                        String newName = name.substring(name.indexOf(46) + 1);
                        value = prop.getProperty(newName, defaultValue);
                    }
                }
                field.setAccessible(true);
                if (null == value) continue;
                try {
                    ClassUtils.setFieldValeByType(field, obj, value);
                }
                catch (Exception e) {
                    LOGGER.error(String.format("invalid config: %s", name), e);
                }
            }
        }
        catch (Exception e) {
            throw new Exception("error while autowire config file", e);
        }
    }

    public static void autowareConfig(Object obj, String propertyFilePath) throws Exception {
        Properties prop = DisconfAutowareConfig.getProperties(propertyFilePath);
        if (null == prop || obj == null) {
            throw new Exception("cannot autowareConfig " + propertyFilePath);
        }
        DisconfAutowareConfig.autowareConfig(obj, prop);
    }

    private static void autowareStaticConfig(Class<?> cls, Properties prop) throws Exception {
        if (null == prop) {
            throw new Exception("cannot autowareConfig null");
        }
        try {
            Field[] fields;
            for (Field field : fields = cls.getDeclaredFields()) {
                if (!field.isAnnotationPresent(DisconfFileItem.class) || !Modifier.isStatic(field.getModifiers())) continue;
                field.setAccessible(true);
                String name = field.getName();
                String value = prop.getProperty(name, null);
                if (value == null) continue;
                ClassUtils.setFieldValeByType(field, null, String.valueOf(value));
            }
        }
        catch (Exception e) {
            throw new Exception("error while autowire config file", e);
        }
    }

    public static void autowareStaticConfig(Class<?> cls, String propertyFilePath) throws Exception {
        Properties prop = DisconfAutowareConfig.getProperties(propertyFilePath);
        if (null == prop) {
            throw new Exception("cannot autowareConfig " + propertyFilePath);
        }
        DisconfAutowareConfig.autowareStaticConfig(cls, prop);
    }
}

