/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.cloud.middleware.embed.proteus.client.utils;

import com.yonyou.cloud.middleware.model.ILogger;
import com.yonyou.cloud.middleware.model.MwLogFactory;
import java.net.URL;
import java.net.URLDecoder;

public final class ClassLoaderUtil {
    protected static final ILogger LOGGER = MwLogFactory.getLogger(ClassLoaderUtil.class);
    private static String classPath = "";
    private static ClassLoader loader = Thread.currentThread().getContextClassLoader();

    private ClassLoaderUtil() {
    }

    public static String getClassPath() {
        return classPath;
    }

    public static ClassLoader getLoader() {
        return loader;
    }

    static {
        if (loader == null) {
            LOGGER.info("using system class loader!");
            loader = ClassLoader.getSystemClassLoader();
        }
        try {
            URL url = loader.getResource("");
            classPath = url.getPath();
            classPath = URLDecoder.decode(classPath, "utf-8");
            if (classPath.contains(".jar!")) {
                LOGGER.warn("using config file inline jar!");
                classPath = System.getProperty("user.dir");
            }
        }
        catch (Exception e) {
            LOGGER.warn("cannot get classpath using getResource(), now using user.dir");
            classPath = System.getProperty("user.dir");
        }
        LOGGER.info("classpath: {" + classPath + "}");
    }
}

