/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.cloud.middleware.embed.proteus.client.utils;

import com.yonyou.cloud.middleware.embed.proteus.client.common.annotations.DisconfFileItem;
import com.yonyou.cloud.middleware.embed.proteus.client.common.annotations.DisconfItem;
import com.yonyou.cloud.middleware.embed.proteus.client.common.constants.DisConfigTypeEnum;
import com.yonyou.cloud.middleware.model.ILogger;
import com.yonyou.cloud.middleware.model.MwLogFactory;
import com.yonyou.cloud.utils.ClassUtils;
import com.yonyou.cloud.utils.StringUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Set;

public class MethodUtils {
    protected static final ILogger LOGGER = MwLogFactory.getLogger(MethodUtils.class);

    public static Field getFieldFromMethod(Method method, Field[] expectedFields, DisConfigTypeEnum disConfigTypeEnum) {
        String fieldName;
        if (disConfigTypeEnum.equals((Object)DisConfigTypeEnum.FILE)) {
            DisconfFileItem disconfFileItem = method.getAnnotation(DisconfFileItem.class);
            fieldName = disconfFileItem.associateField();
        } else {
            DisconfItem disItem = method.getAnnotation(DisconfItem.class);
            fieldName = disItem.associateField();
        }
        if (StringUtils.isEmpty(fieldName)) {
            fieldName = ClassUtils.getFieldNameByGetMethodName(method.getName());
        }
        for (Field field : expectedFields) {
            if (!field.getName().equals(fieldName)) continue;
            return field;
        }
        LOGGER.error(method.toString() + " cannot get its related field name. ");
        return null;
    }

    public static Method getSetterMethodFromField(Class<?> curClass, Field field) {
        String fieldName = field.getName().toLowerCase();
        Set<Method> methods = ClassUtils.getAllMethod(curClass);
        for (Method method : methods) {
            if (!method.getName().toLowerCase().equals("set" + fieldName) && !method.getName().toLowerCase().equals("is" + fieldName)) continue;
            return method;
        }
        return null;
    }
}

