/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.cloud.middleware.embed.proteus.client.utils;

import com.yonyou.cloud.middleware.model.ILogger;
import com.yonyou.cloud.middleware.model.MwLogFactory;
import com.yonyou.cloud.utils.FileUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;

public final class OsUtil {
    protected static final ILogger logger = MwLogFactory.getLogger(OsUtil.class);

    private OsUtil() {
    }

    public static boolean makeDirs(String filePath) {
        File f = new File(filePath);
        if (!f.exists()) {
            return f.mkdirs();
        }
        return true;
    }

    public static boolean isFileExist(String filePathString) throws Exception {
        File f = new File(filePathString);
        return f.exists();
    }

    public static String pathJoin(String ... pathElements) {
        String path;
        if (pathElements == null || pathElements.length == 0) {
            path = File.separator;
        } else {
            StringBuffer sb = new StringBuffer();
            for (String pathElement : pathElements) {
                if (pathElement.length() <= 0) continue;
                sb.append(pathElement);
                sb.append(File.separator);
            }
            if (sb.length() > 0) {
                sb.deleteCharAt(sb.length() - 1);
            }
            path = sb.toString();
        }
        return path;
    }

    public static String getRelativePath(File file, File folder) {
        String folderPath;
        String filePath = file.getAbsolutePath();
        if (filePath.startsWith(folderPath = folder.getAbsolutePath())) {
            return filePath.substring(folderPath.length() + 1);
        }
        return null;
    }

    public static void transferFile(File src, File dest) throws Exception {
        if (dest.exists()) {
            dest.delete();
        }
        FileUtils.copyFile(src, dest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void transferFileAtom(File src, File dest, boolean isDeleteSource) throws Exception {
        File lockFile = new File(dest + ".lock");
        FileOutputStream outStream = null;
        FileLock lock = null;
        try {
            outStream = new FileOutputStream(lockFile);
            FileChannel channel = outStream.getChannel();
            try {
                int tryTime = 0;
                while (tryTime < 3) {
                    lock = channel.tryLock();
                    if (lock != null) {
                        if (dest.exists() && FileUtils.isFileEqual(src, dest)) {
                            if (isDeleteSource) {
                                src.delete();
                            }
                        } else {
                            logger.debug("start to replace " + src.getAbsolutePath() + " to " + dest.getAbsolutePath());
                            OsUtil.transferFile(src, dest);
                            if (isDeleteSource) {
                                src.delete();
                            }
                        }
                        break;
                    }
                    logger.warn("try lock failed. sleep and try " + tryTime);
                    ++tryTime;
                    try {
                        Thread.sleep(1000L * (long)tryTime);
                    }
                    catch (Exception e) {
                        logger.error("", e);
                    }
                }
            }
            catch (IOException e) {
                logger.warn(e.toString());
            }
        }
        catch (FileNotFoundException e) {
            logger.warn(e.toString());
        }
        finally {
            if (null != lock) {
                try {
                    lock.release();
                }
                catch (IOException e) {
                    logger.warn(e.toString());
                }
            }
            if (outStream != null) {
                try {
                    outStream.close();
                }
                catch (IOException e) {
                    logger.warn(e.toString());
                }
            }
        }
    }
}

