/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.cloud.middleware.embed.proteus.client.utils;

import com.yonyou.cloud.middleware.model.ILogger;
import com.yonyou.cloud.middleware.model.MwLogFactory;
import com.yonyou.cloud.utils.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;
import java.util.regex.Pattern;

public class PropertyUtil {
    protected static final ILogger LOGGER = MwLogFactory.getLogger(PropertyUtil.class);
    private static String confFileUrl;
    public static final String SYSTEM_PROPERTIES_MODE_NEVER = "0";
    public static final String SYSTEM_PROPERTIES_MODE_FALLBACK = "1";
    public static final String SYSTEM_PROPERTIES_MODE_OVERRIDE = "2";
    private static Properties prop;
    private static String systemPropertyMode;

    public static void setConfFileUrl(String confFileUrl) {
        PropertyUtil.confFileUrl = confFileUrl;
        PropertyUtil.init();
    }

    private static void init() {
        prop = new Properties();
        PropertyUtil.loadData();
    }

    public static void reload() {
        PropertyUtil.loadData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadData() {
        InputStream in = null;
        InputStreamReader inr = null;
        try {
            File file = null;
            String confFileUrl = PropertyUtil.getConfigFilePath();
            if (StringUtils.isNotBlank(confFileUrl)) {
                file = new File(confFileUrl);
            }
            in = file != null && file.exists() ? new FileInputStream(file) : Thread.currentThread().getContextClassLoader().getResourceAsStream("application.properties");
            prop = new Properties();
            if (in != null) {
                inr = new InputStreamReader(in);
                prop.load(inr);
                systemPropertyMode = prop.getProperty("uap.system.properties.mode");
            }
            systemPropertyMode = StringUtils.isNotBlank(systemPropertyMode) && Pattern.matches("[012]", systemPropertyMode) ? systemPropertyMode : SYSTEM_PROPERTIES_MODE_OVERRIDE;
        }
        catch (IOException e) {
            LOGGER.error("Proteus Fail to load application.properties", e);
        }
        finally {
            if (inr != null) {
                try {
                    inr.close();
                }
                catch (IOException e) {
                    LOGGER.error("Fail to Close inputStream", e);
                }
            }
        }
    }

    private static String getConfigFilePath() {
        String filePath = null;
        if (StringUtils.isBlank(filePath)) {
            filePath = System.getProperty("iuap.server.conf.url");
        }
        if (StringUtils.isBlank(filePath)) {
            filePath = System.getenv("iuap.server.conf.url");
        }
        if (StringUtils.isBlank(filePath)) {
            filePath = confFileUrl;
        }
        return filePath;
    }

    public static String getPropertyByKey(String key) {
        String value = null;
        if (SYSTEM_PROPERTIES_MODE_OVERRIDE.equals(systemPropertyMode)) {
            value = PropertyUtil.resolveSystemProperty(key);
        }
        if (StringUtils.isBlank(value)) {
            value = prop.getProperty(key);
        }
        if (StringUtils.isBlank(value) && SYSTEM_PROPERTIES_MODE_FALLBACK.equals(systemPropertyMode)) {
            value = PropertyUtil.resolveSystemProperty(key);
        }
        return StringUtils.isBlank(value) ? "" : value;
    }

    public static String getPropertyByKey(String key, String defaultValue) {
        String value = null;
        if (SYSTEM_PROPERTIES_MODE_OVERRIDE.equals(systemPropertyMode)) {
            value = PropertyUtil.resolveSystemProperty(key);
        }
        if (StringUtils.isBlank(value)) {
            value = prop.getProperty(key);
        }
        if (StringUtils.isBlank(value) && SYSTEM_PROPERTIES_MODE_FALLBACK.equals(systemPropertyMode)) {
            value = PropertyUtil.resolveSystemProperty(key);
        }
        return StringUtils.isBlank(value) ? defaultValue : value;
    }

    private static String resolveSystemProperty(String key) {
        try {
            String value = System.getProperty(key);
            if (StringUtils.isBlank(value)) {
                value = System.getenv(key);
            }
            return value;
        }
        catch (Exception ex) {
            LOGGER.debug("Could not access system property '" + key + "': " + ex);
            return null;
        }
    }

    static {
        prop = null;
        PropertyUtil.init();
    }
}

