/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.cloud.middleware.iris;

import com.yonyou.cloud.middleware.AppRuntimeEnvironment;
import com.yonyou.cloud.middleware.iris.AttributeEntry;
import com.yonyou.cloud.middleware.iris.RPCInvocationInfo;
import com.yonyou.cloud.utils.StringUtils;

public class RPCInvocationInfoProxy {
    private static final ThreadLocal<RPCInvocationInfo> threadLocal = new ThreadLocal<RPCInvocationInfo>(){

        @Override
        protected RPCInvocationInfo initialValue() {
            return RPCInvocationInfoProxy.getInvocationInfo();
        }
    };

    private static RPCInvocationInfo getInvocationInfo() {
        String providerId = AppRuntimeEnvironment.getProviderId();
        String appCode = AppRuntimeEnvironment.getAppCode();
        String codecProto = "";
        RPCInvocationInfo invocationInfo = new RPCInvocationInfo(providerId, appCode, codecProto);
        return invocationInfo;
    }

    public static String getConsumerProviderId() {
        if (threadLocal.get() == null) {
            return null;
        }
        return threadLocal.get().getProviderId();
    }

    public static String getConsumerAppId() {
        if (threadLocal.get() == null) {
            return null;
        }
        return threadLocal.get().getAppId();
    }

    public static String getProto() {
        if (threadLocal.get() == null) {
            return null;
        }
        return threadLocal.get().getProto();
    }

    public static String getInstanceZone() {
        if (threadLocal.get() == null) {
            return null;
        }
        return threadLocal.get().getSessionZone();
    }

    public static String getAttribute(String key) {
        if (threadLocal.get() == null) {
            return null;
        }
        AttributeEntry[] attributes = threadLocal.get().getAttributes();
        if (attributes != null && attributes.length > 0) {
            for (AttributeEntry a : attributes) {
                if (!StringUtils.equals(a.getKey(), key)) continue;
                return a.getValue();
            }
        }
        return null;
    }

    public static void reset() {
        threadLocal.remove();
    }

    public static void setConsumerProviderId(String consumerProviderId) {
        threadLocal.get().setProviderId(consumerProviderId);
    }

    public static void setConsumerAppId(String consumerAppId) {
        threadLocal.get().setAppId(consumerAppId);
    }

    public static void setProto(String proto) {
        threadLocal.get().setProto(proto);
    }

    public static void setInstanceZone(String sessionZone) {
        threadLocal.get().setSessionZone(sessionZone);
    }

    public static void setAttribute(AttributeEntry[] attributes) {
        threadLocal.get().setAttributes(attributes);
    }

    public static void setReadTimeout(long readTimeout) {
        threadLocal.get().setReadTimeout(readTimeout);
    }

    public static void setWriteTimeout(long writeTimeout) {
        threadLocal.get().setWriteTimeout(writeTimeout);
    }
}

