/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.cloud.middleware.rpc;

import com.yonyou.cloud.bean.RemoteCallInfo;
import com.yonyou.cloud.constant.RemoteCallConstants;
import com.yonyou.cloud.exception.ApiDeclarativeException;
import com.yonyou.cloud.middleware.AppRuntimeEnvironment;
import com.yonyou.cloud.middleware.iris.ExecuteResult;
import com.yonyou.cloud.middleware.iris.IProviderService;
import com.yonyou.cloud.middleware.iris.RemoteInvocation;
import com.yonyou.cloud.middleware.model.ILogFactory;
import com.yonyou.cloud.middleware.model.ILogger;
import com.yonyou.cloud.middleware.rpc.transport.CodecAdapterFactory;
import com.yonyou.cloud.middleware.rpc.transport.ICodecAdapter;
import com.yonyou.cloud.mw.MwLocator;
import com.yonyou.cloud.mwclient.MwClientStartUp;
import com.yonyou.cloud.reqservice.IRemoteCallInfoManagerService;
import com.yonyou.cloud.utils.IDynStubUtil;
import com.yonyou.cloud.utils.IOUtils;
import com.yonyou.cloud.utils.InstanceManagerHolder;
import com.yonyou.cloud.utils.ServInstUtils;
import com.yonyou.cloud.utils.SignVerifyUtilHolder;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RpcInvokerServlet
extends HttpServlet
implements RemoteCallConstants {
    private static IDynStubUtil stubUtil = MwLocator.lookup(IDynStubUtil.class);
    static final ILogger logger = MwLocator.lookup(ILogFactory.class).getLogger(RpcInvokerServlet.class);
    private static final long serialVersionUID = 1L;
    private static String INST_IDENTIFIER = null;
    private static final int SC_OK = 200;

    public void init(ServletConfig config) throws ServletException {
        String alone;
        super.init(config);
        if (AppRuntimeEnvironment.getServlet_context() == null) {
            AppRuntimeEnvironment.setServlet_context(config.getServletContext());
            AppRuntimeEnvironment.context = AppRuntimeEnvironment.getServlet_context().getContextPath();
        }
        if ("true".equals(alone = config.getInitParameter("alone"))) {
            try {
                MwClientStartUp.starup();
            }
            catch (InstantiationException e) {
                logger.error("RpcInvokerServlet \u521d\u59cb\u5316\u5931\u8d25");
            }
            catch (IllegalAccessException e) {
                logger.error("RpcInvokerServlet \u521d\u59cb\u5316\u5931\u8d25");
            }
            catch (ClassNotFoundException e) {
                logger.error("RpcInvokerServlet \u521d\u59cb\u5316\u5931\u8d25");
            }
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setStatus(200);
        PrintWriter writer = resp.getWriter();
        if (null == INST_IDENTIFIER && null == (INST_IDENTIFIER = ServInstUtils.buildInstIdentifier(AppRuntimeEnvironment.getAppCode(), AppRuntimeEnvironment.getProviderId(), AppRuntimeEnvironment.getProfile()))) {
            throw new RuntimeException("\u5b9e\u4f8bID\u4e0d\u80fd\u4e3a\u7a7a:" + INST_IDENTIFIER);
        }
        resp.addHeader("rpc.destInst", INST_IDENTIFIER);
        writer.write("ok");
        writer.flush();
        writer.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        ICodecAdapter codec = null;
        try {
            String requestURI = req.getRequestURI();
            requestURI = requestURI.substring(requestURI.indexOf("/CloudRemoteCall/") + "/CloudRemoteCall/".length());
            String[] uris = requestURI.split("/");
            String serviceName = uris[0];
            String contentType = req.getContentType();
            CodecAdapterFactory caf = CodecAdapterFactory.getInstance();
            codec = caf.get(contentType);
            RemoteInvocation invocation = codec.decodeRemoteInvocation((InputStream)req.getInputStream());
            stubUtil.processTypeTransform(invocation);
            RemoteCallInfo rci = MwLocator.lookup(IRemoteCallInfoManagerService.class).find(AppRuntimeEnvironment.getAppCode(), AppRuntimeEnvironment.getProviderId(), serviceName);
            if (rci == null) {
                throw new IllegalAccessException(serviceName + " not found or not public .");
            }
            ExecuteResult remoteInvocationResult = MwLocator.lookup(IProviderService.class).getExecuteResult(serviceName, invocation);
            if (remoteInvocationResult.hasException()) {
                this.processException(resp, remoteInvocationResult, codec);
            } else {
                ServletOutputStream outputStream = resp.getOutputStream();
                codec.encode(remoteInvocationResult, (OutputStream)outputStream);
                outputStream.flush();
                IOUtils.closeQuietly((Closeable)outputStream);
            }
        }
        catch (Exception e) {
            this.processException(resp, new ExecuteResult(e), codec);
        }
        finally {
            CTX_LINK_TRACE.remove();
        }
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setStatus(200);
        PrintWriter writer = resp.getWriter();
        if (SignVerifyUtilHolder.verifyToken(req)) {
            InstanceManagerHolder.offline();
            writer.write("offline ok");
            writer.flush();
            writer.close();
        } else {
            writer.write("offline fail");
            writer.flush();
            writer.close();
        }
    }

    public void processException(HttpServletResponse resp, ExecuteResult ret, ICodecAdapter codec) throws IOException {
        resp.setStatus(200);
        ServletOutputStream outputStream = resp.getOutputStream();
        Throwable ex = ret.getException();
        ex = this.getInnerException(ex);
        if (ApiDeclarativeException.class == ex.getClass()) {
            codec.encode(ret, (OutputStream)outputStream);
        } else {
            codec.encode(new ExecuteResult(ex), (OutputStream)outputStream);
        }
        outputStream.flush();
        IOUtils.closeQuietly((Closeable)outputStream);
    }

    private Throwable getInnerException(Throwable ex) {
        if (UndeclaredThrowableException.class.isInstance(ex)) {
            ex = ((InvocationTargetException)((UndeclaredThrowableException)ex).getCause()).getTargetException();
        } else if (InvocationTargetException.class.isInstance(ex)) {
            ex = ((InvocationTargetException)ex).getTargetException();
        }
        return ex;
    }
}

