/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.cloud.middleware.rpc.transport;

import com.yonyou.cloud.middleware.rpc.transport.ICodecAdapter;
import com.yonyou.cloud.utils.StringUtils;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class CodecAdapterFactory {
    private static final CodecAdapterFactory CAF = new CodecAdapterFactory();
    String defaultProto;
    public static final String APPLICATION_OCTET_STREAM_VALUE = "application/octet-stream";
    public static final String APPLICATION_JSON_VALUE = "application/json";
    public static final String APPLICATION_JSON_UTF8_VALUE = "application/json;charset=UTF-8";
    private Map<String, ICodecAdapter> codeC = new ConcurrentHashMap<String, ICodecAdapter>();

    public static final CodecAdapterFactory getInstance() {
        return CAF;
    }

    private CodecAdapterFactory() {
        String defaultProto = "hessian";
        this.setDefaultProto(defaultProto);
    }

    void setDefaultProto(String defaultProto) {
        if (StringUtils.equals(defaultProto, "hessian")) {
            this.defaultProto = APPLICATION_OCTET_STREAM_VALUE;
        }
        if (StringUtils.equals(defaultProto, "json")) {
            this.defaultProto = APPLICATION_JSON_UTF8_VALUE;
        }
    }

    public void put(String type, ICodecAdapter adapter) {
        this.codeC.put(type, adapter);
    }

    public ICodecAdapter get(String type) {
        ICodecAdapter adapter;
        if (type == null) {
            type = this.getDefaultProto();
        }
        if ((adapter = this.codeC.get(type)) == null) {
            adapter = this.codeC.get(this.defaultProto);
        }
        return adapter;
    }

    public String getDefaultProto() {
        return this.defaultProto;
    }

    public ICodecAdapter get() {
        return this.get(this.getDefaultProto());
    }
}

