/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.cloud.mwclient.sentinel;

import com.yonyou.cloud.mwclient.sentinel.model.Entry;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class EntryManager {
    private Map<String, Entry> entryMap = new ConcurrentHashMap<String, Entry>();
    private ThreadLocal<Entry> rootEntry = new ThreadLocal();
    private static EntryManager instance = new EntryManager();

    public static void addEntry(Entry entry) {
        EntryManager.instance.entryMap.put(EntryManager.getGeneralName(entry), entry);
    }

    public static Entry getEntry(String desc) {
        return EntryManager.instance.entryMap.get(desc);
    }

    public static Entry getEntry(String desc, String rootDesc) {
        return EntryManager.instance.entryMap.get(EntryManager.getGeneralName(desc, rootDesc));
    }

    public static void setRoot(Entry entry) {
        if (EntryManager.instance.rootEntry.get() != null) {
            EntryManager.instance.rootEntry.set(entry);
        }
    }

    public static void clearRoot() {
        EntryManager.instance.rootEntry.remove();
    }

    public static void statTrace(String desc, String key) {
        if (EntryManager.instance.entryMap.get(desc) != null) {
            EntryManager.instance.entryMap.get(desc).statTrace(key);
        }
    }

    public static String getGeneralName(Entry entry) {
        if (entry.getRootDesc() != null) {
            return entry.getRootDesc() + "#" + entry.getDesc();
        }
        return entry.getDesc();
    }

    public static String getGeneralName(String desc, String rootDesc) {
        if (rootDesc != null) {
            return rootDesc + "#" + desc;
        }
        return desc;
    }
}

