/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.cloud.mwclient.sentinel.model;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class AutoSwitch {
    private static final long millisForMinute = 60000L;
    private AtomicLong currentTime;
    private AtomicLong totalCount;
    private AtomicLong failCount;
    private AtomicLong threadHold;
    private AtomicInteger collaps;
    private AtomicBoolean off = new AtomicBoolean(false);
    private String methodName;

    public AutoSwitch(String methodName) {
        this.currentTime = new AtomicLong(System.currentTimeMillis());
        this.methodName = methodName;
        this.collaps = new AtomicInteger(5000);
        this.threadHold = new AtomicLong(50L);
        this.failCount = new AtomicLong(0L);
        this.totalCount = new AtomicLong(0L);
    }

    public static AutoSwitch newInstance(String methodName) {
        return new AutoSwitch(methodName);
    }

    public boolean off() {
        return this.off.get();
    }

    public void stat(boolean result) {
        long fail;
        long millis = System.currentTimeMillis();
        long currentMills = this.currentTime.get();
        if (!this.isCurrentMinute(millis)) {
            this.failCount.set(0L);
            this.totalCount.set(0L);
            this.currentTime.compareAndSet(millis, currentMills);
            if (result && this.off.get()) {
                this.off.compareAndSet(false, true);
            }
            if (!result) {
                this.failCount.incrementAndGet();
            }
            this.totalCount.incrementAndGet();
            return;
        }
        if (this.off.get()) {
            if (millis - currentMills > (long)this.collaps.get()) {
                this.currentTime.compareAndSet(millis, currentMills);
                if (result) {
                    this.off.compareAndSet(true, false);
                }
            }
            return;
        }
        if (!result) {
            this.failCount.incrementAndGet();
        }
        if ((fail = this.failCount.get()) > this.threadHold.get()) {
            this.off.compareAndSet(false, true);
        }
    }

    private boolean isCurrentMinute(long millis) {
        return millis - this.currentTime.get() < 60000L;
    }
}

