/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.cloud.mwclient.sentinel.model;

import java.util.Date;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;

public class CountArray {
    private static final Long SECOND_MILLS = 1000L;
    private AtomicLongArray qpsArray;
    private AtomicLongArray qpsMillsArray;
    private AtomicLong currentMills;
    private AtomicLong limitCount;
    private AtomicLong totalLimitCount;
    private boolean smallQps;
    private AtomicLong totalQps;
    private AtomicBoolean overlap;
    private AtomicLong totalCount;
    private AtomicLong unitMills;
    private AtomicInteger index = new AtomicInteger(0);

    public static Long getSecondMills() {
        return SECOND_MILLS;
    }

    public AtomicLongArray getQpsArray() {
        return this.qpsArray;
    }

    public AtomicLongArray getQpsMillsArray() {
        return this.qpsMillsArray;
    }

    public AtomicLong getCurrentMills() {
        return this.currentMills;
    }

    public AtomicLong getLimitCount() {
        return this.limitCount;
    }

    public AtomicLong getTotalLimitCount() {
        return this.totalLimitCount;
    }

    public boolean isSmallQps() {
        return this.smallQps;
    }

    public AtomicLong getTotalQps() {
        return this.totalQps;
    }

    public AtomicBoolean getOverlap() {
        return this.overlap;
    }

    public AtomicLong getTotalCount() {
        return this.totalCount;
    }

    public AtomicLong getUnitMills() {
        return this.unitMills;
    }

    public AtomicInteger getIndex() {
        return this.index;
    }

    public static CountArray build(long limitCount, int unitMills) {
        if (unitMills == -1) {
            unitMills = SECOND_MILLS.intValue();
        }
        CountArray countArray = new CountArray();
        countArray.limitCount = new AtomicLong(limitCount == -1L ? -1L : limitCount / (SECOND_MILLS / (long)unitMills));
        countArray.totalCount = new AtomicLong(limitCount);
        countArray.smallQps = limitCount < SECOND_MILLS / (long)unitMills;
        countArray.currentMills = new AtomicLong(new Date().getTime());
        countArray.unitMills = new AtomicLong(unitMills);
        int len = 1000 / unitMills;
        countArray.qpsArray = new AtomicLongArray(len);
        countArray.qpsMillsArray = new AtomicLongArray(len);
        countArray.totalQps = new AtomicLong(0L);
        CountArray.initQpsMillsArray(countArray);
        countArray.overlap = new AtomicBoolean(false);
        return countArray;
    }

    private static void initQpsMillsArray(CountArray countArray) {
        int len = countArray.qpsMillsArray.length();
        for (int i = 0; i < len; ++i) {
            countArray.qpsMillsArray.set(i, countArray.currentMills.get() + (long)i * countArray.unitMills.get());
        }
    }

    public boolean overLimit() {
        long now = new Date().getTime();
        long curMills = this.currentMills.get();
        long laps = now - this.currentMills.get();
        int curIndex = this.index.get();
        long step = laps / this.unitMills.get();
        Long nextIndex = ((long)curIndex + step) % (long)this.qpsArray.length();
        this.index.compareAndSet(curIndex, nextIndex.intValue());
        if (laps > this.unitMills.get()) {
            this.currentMills.compareAndSet(curMills, now);
            this.qpsArray.compareAndSet(nextIndex.intValue(), this.qpsArray.get(this.index.get()), 1L);
            this.totalQps.compareAndSet(this.totalQps.get(), 0L);
        } else {
            long count = this.qpsArray.get(nextIndex.intValue());
            this.qpsArray.compareAndSet(nextIndex.intValue(), count, count + 1L);
            this.totalQps.incrementAndGet();
        }
        if (this.limitCount.get() == -1L) {
            return false;
        }
        if (this.totalCount.get() == 0L) {
            return true;
        }
        return this.limitCompare(this.qpsArray.get(this.index.get()), this.limitCount.get());
    }

    private boolean limitCompare(Long qps, Long limitCount) {
        if (this.smallQps) {
            return this.totalQps.get() > this.totalCount.get();
        }
        return qps > limitCount;
    }

    public void exit() {
    }

    public long totalCount() {
        return this.qpsArray.get(this.index.get()) * (long)this.qpsArray.length();
    }

    public static void main(String[] args) {
        try {
            long start = new Date().getTime();
            CountArray countArray = CountArray.build(300L, 200);
            for (int count = 0; count < 3000; ++count) {
                if (countArray.overLimit()) {
                    System.out.print("qps over limit, qps is: " + countArray.totalCount() + ", index is: " + countArray.getIndex() + ", arrayQps is: " + countArray.getQpsArray().get(countArray.getIndex().get()) + "\n");
                }
                Thread.sleep(1L);
            }
            countArray.exit();
            System.out.print(countArray.totalCount());
            countArray.exit();
            long end = new Date().getTime();
            long cost = end - start;
            System.out.print("cost mills: " + cost);
        }
        catch (Exception e) {
            System.out.print(e.getMessage());
        }
    }
}

